/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Communication;
import org.hl7.fhir.r4.model.Type;

public class CommunicationMutatorProvider
extends BaseDomainResourceMutatorProvider<Communication> {
    public CommunicationMutatorProvider() {
        super(CommunicationMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Communication>> createMutators() {
        LinkedList<FuzzingMutator<Communication>> mutators = new LinkedList<FuzzingMutator<Communication>>();
        mutators.add((ctx, com) -> ctx.fuzzChild(com, () -> ((Communication)com).hasEncounter(), () -> ((Communication)com).getEncounter()));
        mutators.add((ctx, com) -> ctx.fuzzChildTypes(com.getClass(), com.getBasedOn(), () -> ((Communication)com).getBasedOnFirstRep()));
        mutators.add((ctx, com) -> ctx.fuzzChildTypes(com.getClass(), com.getAbout(), () -> ((Communication)com).getAboutFirstRep()));
        mutators.add((ctx, com) -> ctx.fuzzChildTypes(com.getClass(), com.getIdentifier(), () -> ((Communication)com).getIdentifierFirstRep()));
        mutators.add((ctx, com) -> ctx.fuzzChildTypes(com.getClass(), com.getInResponseTo(), () -> ((Communication)com).getInResponseToFirstRep()));
        mutators.add((ctx, com) -> ctx.fuzzChildTypes(com.getClass(), com.getInstantiatesUri(), () -> ((Communication)com).addInstantiatesUriElement()));
        mutators.add((ctx, com) -> ctx.fuzzChildTypes(com.getClass(), com.getInstantiatesCanonical(), () -> ((Communication)com).addInstantiatesCanonicalElement()));
        mutators.add((ctx, com) -> ctx.fuzzChildTypes(com.getClass(), com.getMedium(), () -> ((Communication)com).getMediumFirstRep()));
        mutators.add((ctx, com) -> ctx.fuzzChildTypes(com.getClass(), com.getNote(), () -> ((Communication)com).getNoteFirstRep()));
        mutators.add((ctx, com) -> ctx.fuzzChildTypes(com.getClass(), com.getPartOf(), () -> ((Communication)com).getPartOfFirstRep()));
        mutators.add((ctx, com) -> ctx.fuzzChildTypes(com.getClass(), com.getReasonCode(), () -> ((Communication)com).getReasonCodeFirstRep()));
        mutators.add((ctx, com) -> ctx.fuzzChildTypes(com.getClass(), com.getReasonReference(), () -> ((Communication)com).getReasonReferenceFirstRep()));
        mutators.add((ctx, com) -> ctx.fuzzChildTypes(com.getClass(), com.getRecipient(), () -> ((Communication)com).getRecipientFirstRep()));
        mutators.add((ctx, com) -> ctx.fuzzChildTypes(com.getClass(), com.getAbout(), () -> ((Communication)com).getAboutFirstRep()));
        mutators.add((ctx, com) -> ctx.fuzzChildTypes(com.getClass(), com.getCategory(), () -> ((Communication)com).getCategoryFirstRep()));
        mutators.add((ctx, com) -> {
            List<Type> payloads = com.getPayload().stream().map(Communication.CommunicationPayloadComponent::getContent).toList();
            return ctx.fuzzChildTypes(com.getClass(), payloads);
        });
        mutators.add((ctx, com) -> {
            Communication.CommunicationPriority priority = com.getPriority();
            Communication.CommunicationPriority fpriority = ctx.randomness().chooseRandomFromEnum(Communication.CommunicationPriority.class, priority);
            com.setPriority(fpriority);
            return FuzzingLogEntry.operation(MessageFormat.format("Change Priority of Communication {0}: {1} -> {2}", com.getId(), priority, fpriority));
        });
        return mutators;
    }
}

