/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.ClaimResponse;

public class ClaimResponseMutatorProvider
extends BaseDomainResourceMutatorProvider<ClaimResponse> {
    public ClaimResponseMutatorProvider() {
        super(ClaimResponseMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<ClaimResponse>> createMutators() {
        LinkedList<FuzzingMutator<ClaimResponse>> mutators = new LinkedList<FuzzingMutator<ClaimResponse>>();
        mutators.add((ctx, claim) -> ctx.fuzzChildTypes(claim.getClass(), claim.getIdentifier(), () -> ((ClaimResponse)claim).getIdentifierFirstRep()));
        mutators.add((ctx, claim) -> ctx.fuzzChildTypes(claim.getClass(), claim.getCommunicationRequest(), () -> ((ClaimResponse)claim).getCommunicationRequestFirstRep()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((ClaimResponse)claim).hasType(), () -> ((ClaimResponse)claim).getType()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((ClaimResponse)claim).hasSubType(), () -> ((ClaimResponse)claim).getSubType()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((ClaimResponse)claim).hasCreated(), () -> ((ClaimResponse)claim).getCreatedElement()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((ClaimResponse)claim).hasFundsReserve(), () -> ((ClaimResponse)claim).getFundsReserve()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((ClaimResponse)claim).hasInsurer(), () -> ((ClaimResponse)claim).getInsurer()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((ClaimResponse)claim).hasPatient(), () -> ((ClaimResponse)claim).getPatient()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((ClaimResponse)claim).hasPayeeType(), () -> ((ClaimResponse)claim).getPayeeType()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((ClaimResponse)claim).hasDisposition(), () -> ((ClaimResponse)claim).getDispositionElement()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((ClaimResponse)claim).hasForm(), () -> ((ClaimResponse)claim).getForm()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((ClaimResponse)claim).hasFormCode(), () -> ((ClaimResponse)claim).getFormCode()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((ClaimResponse)claim).hasPreAuthPeriod(), () -> ((ClaimResponse)claim).getPreAuthPeriod()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((ClaimResponse)claim).hasPreAuthRef(), () -> ((ClaimResponse)claim).getPreAuthRefElement()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((ClaimResponse)claim).hasRequest(), () -> ((ClaimResponse)claim).getRequest()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((ClaimResponse)claim).hasRequestor(), () -> ((ClaimResponse)claim).getRequestor()));
        return mutators;
    }
}

