/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Claim;

public class ClaimMutatorProvider
extends BaseDomainResourceMutatorProvider<Claim> {
    public ClaimMutatorProvider() {
        super(ClaimMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Claim>> createMutators() {
        LinkedList<FuzzingMutator<Claim>> mutators = new LinkedList<FuzzingMutator<Claim>>();
        mutators.add((ctx, claim) -> ctx.fuzzChildTypes(claim.getClass(), claim.getIdentifier(), () -> ((Claim)claim).getIdentifierFirstRep()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((Claim)claim).hasType(), () -> ((Claim)claim).getType()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((Claim)claim).hasBillablePeriod(), () -> ((Claim)claim).getBillablePeriod()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((Claim)claim).hasSubType(), () -> ((Claim)claim).getSubType()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((Claim)claim).hasPriority(), () -> ((Claim)claim).getPriority()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((Claim)claim).hasProvider(), () -> ((Claim)claim).getProvider()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((Claim)claim).hasCreated(), () -> ((Claim)claim).getCreatedElement()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((Claim)claim).hasEnterer(), () -> ((Claim)claim).getEnterer()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((Claim)claim).hasFacility(), () -> ((Claim)claim).getFacility()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((Claim)claim).hasFundsReserve(), () -> ((Claim)claim).getFundsReserve()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((Claim)claim).hasInsurer(), () -> ((Claim)claim).getInsurer()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((Claim)claim).hasOriginalPrescription(), () -> ((Claim)claim).getOriginalPrescription()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((Claim)claim).hasPatient(), () -> ((Claim)claim).getPatient()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((Claim)claim).hasPrescription(), () -> ((Claim)claim).getPrescription()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((Claim)claim).hasReferral(), () -> ((Claim)claim).getReferral()));
        mutators.add((ctx, claim) -> ctx.fuzzChild(claim, () -> ((Claim)claim).hasTotal(), () -> ((Claim)claim).getTotal()));
        return mutators;
    }
}

