/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.ChargeItem;

public class ChargeItemMutatorProvider
extends BaseDomainResourceMutatorProvider<ChargeItem> {
    public ChargeItemMutatorProvider() {
        super(ChargeItemMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<ChargeItem>> createMutators() {
        LinkedList<FuzzingMutator<ChargeItem>> mutators = new LinkedList<FuzzingMutator<ChargeItem>>();
        mutators.add((ctx, ci) -> ctx.fuzzChildTypes(ci.getClass(), ci.getIdentifier(), () -> ((ChargeItem)ci).getIdentifierFirstRep()));
        mutators.add((ctx, ci) -> ctx.fuzzChildTypes(ci.getClass(), ci.getAccount(), () -> ((ChargeItem)ci).getAccountFirstRep()));
        mutators.add((ctx, ci) -> ctx.fuzzChildTypes(ci.getClass(), ci.getBodysite(), () -> ((ChargeItem)ci).getBodysiteFirstRep()));
        mutators.add((ctx, ci) -> ctx.fuzzChildTypes(ci.getClass(), ci.getNote(), () -> ((ChargeItem)ci).getNoteFirstRep()));
        mutators.add((ctx, ci) -> ctx.fuzzChildTypes(ci.getClass(), ci.getDefinitionCanonical(), () -> ((ChargeItem)ci).addDefinitionCanonicalElement()));
        mutators.add((ctx, ci) -> ctx.fuzzChildTypes(ci.getClass(), ci.getDefinitionUri(), () -> ((ChargeItem)ci).addDefinitionUriElement()));
        mutators.add((ctx, ci) -> ctx.fuzzChildTypes(ci.getClass(), ci.getPartOf(), () -> ((ChargeItem)ci).getPartOfFirstRep()));
        mutators.add((ctx, ci) -> ctx.fuzzChildTypes(ci.getClass(), ci.getReason(), () -> ((ChargeItem)ci).getReasonFirstRep()));
        mutators.add((ctx, ci) -> ctx.fuzzChildTypes(ci.getClass(), ci.getService(), () -> ((ChargeItem)ci).getServiceFirstRep()));
        mutators.add((ctx, ci) -> ctx.fuzzChildTypes(ci.getClass(), ci.getSupportingInformation(), () -> ((ChargeItem)ci).getSupportingInformationFirstRep()));
        mutators.add((ctx, ci) -> ctx.fuzzChild(ci, () -> ((ChargeItem)ci).hasCode(), () -> ((ChargeItem)ci).getCode()));
        mutators.add((ctx, ci) -> ctx.fuzzChild(ci, () -> ((ChargeItem)ci).hasContext(), () -> ((ChargeItem)ci).getContext()));
        mutators.add((ctx, ci) -> ctx.fuzzChild(ci, () -> ((ChargeItem)ci).hasCostCenter(), () -> ((ChargeItem)ci).getCostCenter()));
        mutators.add((ctx, ci) -> ctx.fuzzChild(ci, () -> ((ChargeItem)ci).hasEnteredDate(), () -> ((ChargeItem)ci).getEnteredDateElement()));
        mutators.add((ctx, ci) -> ctx.fuzzChild(ci, () -> ((ChargeItem)ci).hasEnterer(), () -> ((ChargeItem)ci).getEnterer()));
        mutators.add((ctx, ci) -> ctx.fuzzChild(ci, () -> ((ChargeItem)ci).hasFactorOverride(), () -> ((ChargeItem)ci).getFactorOverrideElement()));
        return mutators;
    }
}

