/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.CarePlan;

public class CarePlanMutatorProvider
extends BaseDomainResourceMutatorProvider<CarePlan> {
    public CarePlanMutatorProvider() {
        super(CarePlanMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<CarePlan>> createMutators() {
        LinkedList<FuzzingMutator<CarePlan>> mutators = new LinkedList<FuzzingMutator<CarePlan>>();
        mutators.add((cpx, cp) -> cpx.fuzzChildTypes(cp.getClass(), cp.getIdentifier(), () -> ((CarePlan)cp).getIdentifierFirstRep()));
        mutators.add((cpx, cp) -> cpx.fuzzChildTypes(cp.getClass(), cp.getAddresses(), () -> ((CarePlan)cp).getAddressesFirstRep()));
        mutators.add((cpx, cp) -> cpx.fuzzChildTypes(cp.getClass(), cp.getCategory(), () -> ((CarePlan)cp).getCategoryFirstRep()));
        mutators.add((cpx, cp) -> cpx.fuzzChildTypes(cp.getClass(), cp.getNote(), () -> ((CarePlan)cp).getNoteFirstRep()));
        mutators.add((cpx, cp) -> cpx.fuzzChildTypes(cp.getClass(), cp.getCareTeam(), () -> ((CarePlan)cp).getCareTeamFirstRep()));
        mutators.add((cpx, cp) -> cpx.fuzzChildTypes(cp.getClass(), cp.getBasedOn(), () -> ((CarePlan)cp).getBasedOnFirstRep()));
        mutators.add((cpx, cp) -> cpx.fuzzChildTypes(cp.getClass(), cp.getContributor(), () -> ((CarePlan)cp).getContributorFirstRep()));
        mutators.add((cpx, cp) -> cpx.fuzzChildTypes(cp.getClass(), cp.getGoal(), () -> ((CarePlan)cp).getGoalFirstRep()));
        mutators.add((cpx, cp) -> cpx.fuzzChildTypes(cp.getClass(), cp.getPartOf(), () -> ((CarePlan)cp).getPartOfFirstRep()));
        mutators.add((cpx, cp) -> cpx.fuzzChildTypes(cp.getClass(), cp.getInstantiatesCanonical(), () -> ((CarePlan)cp).addInstantiatesCanonicalElement()));
        mutators.add((cpx, cp) -> cpx.fuzzChildTypes(cp.getClass(), cp.getInstantiatesUri(), () -> ((CarePlan)cp).addInstantiatesUriElement()));
        mutators.add((cpx, cp) -> cpx.fuzzChildTypes(cp.getClass(), cp.getReplaces(), () -> ((CarePlan)cp).getReplacesFirstRep()));
        mutators.add((cpx, cp) -> cpx.fuzzChildTypes(cp.getClass(), cp.getSupportingInfo(), () -> ((CarePlan)cp).getSupportingInfoFirstRep()));
        mutators.add((cpx, cp) -> cpx.fuzzChild(cp, () -> ((CarePlan)cp).hasAuthor(), () -> ((CarePlan)cp).getAuthor()));
        mutators.add((cpx, cp) -> cpx.fuzzChild(cp, () -> ((CarePlan)cp).hasSubject(), () -> ((CarePlan)cp).getSubject()));
        mutators.add((cpx, cp) -> cpx.fuzzChild(cp, () -> ((CarePlan)cp).hasEncounter(), () -> ((CarePlan)cp).getEncounter()));
        mutators.add((cpx, cp) -> cpx.fuzzChild(cp, () -> ((CarePlan)cp).hasPeriod(), () -> ((CarePlan)cp).getPeriod()));
        mutators.add((cpx, cp) -> cpx.fuzzChild(cp, () -> ((CarePlan)cp).hasCreated(), () -> ((CarePlan)cp).getCreatedElement()));
        mutators.add((cpx, cp) -> cpx.fuzzChild(cp, () -> ((CarePlan)cp).hasDescription(), () -> ((CarePlan)cp).getDescriptionElement()));
        mutators.add((cpx, cp) -> cpx.fuzzChild(cp, () -> ((CarePlan)cp).hasTitle(), () -> ((CarePlan)cp).getTitleElement()));
        return mutators;
    }
}

