/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.CapabilityStatement;

public class CapabilityStatementMutatorProvider
extends BaseDomainResourceMutatorProvider<CapabilityStatement> {
    public CapabilityStatementMutatorProvider() {
        super(CapabilityStatementMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<CapabilityStatement>> createMutators() {
        LinkedList<FuzzingMutator<CapabilityStatement>> mutators = new LinkedList<FuzzingMutator<CapabilityStatement>>();
        mutators.add((ctx, cs) -> ctx.fuzzChildTypes(cs.getClass(), cs.getContact(), () -> ((CapabilityStatement)cs).getContactFirstRep()));
        mutators.add((ctx, cs) -> ctx.fuzzChildTypes(cs.getClass(), cs.getJurisdiction(), () -> ((CapabilityStatement)cs).getJurisdictionFirstRep()));
        mutators.add((ctx, cs) -> ctx.fuzzChildTypes(cs.getClass(), cs.getUseContext(), () -> ((CapabilityStatement)cs).getUseContextFirstRep()));
        mutators.add((ctx, cs) -> ctx.fuzzChildTypes(cs.getClass(), cs.getFormat(), () -> ((CapabilityStatement)cs).addFormatElement()));
        mutators.add((ctx, cs) -> ctx.fuzzChildTypes(cs.getClass(), cs.getPatchFormat(), () -> ((CapabilityStatement)cs).addPatchFormatElement()));
        mutators.add((ctx, cs) -> ctx.fuzzChildTypes(cs.getClass(), cs.getImports(), () -> ((CapabilityStatement)cs).addImportsElement()));
        mutators.add((ctx, cs) -> ctx.fuzzChildTypes(cs.getClass(), cs.getInstantiates(), () -> ((CapabilityStatement)cs).addInstantiatesElement()));
        mutators.add((ctx, cs) -> ctx.fuzzChildTypes(cs.getClass(), cs.getImplementationGuide(), () -> ((CapabilityStatement)cs).addImplementationGuideElement()));
        mutators.add((ctx, cs) -> ctx.fuzzChild(cs, () -> ((CapabilityStatement)cs).hasTitle(), () -> ((CapabilityStatement)cs).getTitleElement()));
        mutators.add((ctx, cs) -> ctx.fuzzChild(cs, () -> ((CapabilityStatement)cs).hasName(), () -> ((CapabilityStatement)cs).getNameElement()));
        mutators.add((ctx, cs) -> ctx.fuzzChild(cs, () -> ((CapabilityStatement)cs).hasVersion(), () -> ((CapabilityStatement)cs).getVersionElement()));
        mutators.add((ctx, cs) -> ctx.fuzzChild(cs, () -> ((CapabilityStatement)cs).hasDescription(), () -> ((CapabilityStatement)cs).getDescriptionElement()));
        mutators.add((ctx, cs) -> ctx.fuzzChild(cs, () -> ((CapabilityStatement)cs).hasCopyright(), () -> ((CapabilityStatement)cs).getCopyrightElement()));
        mutators.add((ctx, cs) -> ctx.fuzzChild(cs, () -> ((CapabilityStatement)cs).hasDate(), () -> ((CapabilityStatement)cs).getDateElement()));
        mutators.add((ctx, cs) -> ctx.fuzzChild(cs, () -> ((CapabilityStatement)cs).hasPublisher(), () -> ((CapabilityStatement)cs).getPublisherElement()));
        mutators.add((ctx, cs) -> ctx.fuzzChild(cs, () -> ((CapabilityStatement)cs).hasExperimental(), () -> ((CapabilityStatement)cs).getExperimentalElement()));
        mutators.add((ctx, cs) -> ctx.fuzzChild(cs, () -> ((CapabilityStatement)cs).hasUrl(), () -> ((CapabilityStatement)cs).getUrlElement()));
        return mutators;
    }
}

