/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingContext;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseResourceMutatorProvider;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.UriType;

public class BundleMutatorProvider
extends BaseResourceMutatorProvider<Bundle> {
    public BundleMutatorProvider() {
        super(BundleMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Bundle>> createMutators() {
        LinkedList<FuzzingMutator<Bundle>> mutators = new LinkedList<FuzzingMutator<Bundle>>();
        mutators.add(FuzzingContext::fuzzChildResources);
        mutators.add((ctx, bundle) -> ctx.fuzzChild(bundle.getClass(), () -> ((Bundle)bundle).hasIdentifier(), () -> ((Bundle)bundle).getIdentifier()));
        mutators.add((ctx, bundle) -> {
            List<UriType> uriTypes = bundle.getEntry().stream().map(Bundle.BundleEntryComponent::getFullUrlElement).toList();
            return ctx.fuzzChildTypes(bundle.getClass(), uriTypes, () -> ctx.randomness().fhir().createType(UriType.class));
        });
        mutators.add((ctx, bundle) -> {
            int amount = ctx.randomness().source().nextInt(1, 3);
            List<FuzzingLogEntry> children = IntStream.range(0, amount).mapToObj(idx -> {
                Resource resource = ctx.randomness().fhir().createResource();
                resource.setId(ctx.randomness().uuid());
                resource.setMeta(new Meta().addProfile(ctx.randomness().url()));
                Bundle.BundleEntryComponent entry = new Bundle.BundleEntryComponent().setResource(resource);
                bundle.addEntry(entry);
                if (ctx.randomness().source().nextBoolean()) {
                    return ctx.fuzzChild(bundle.getClass(), resource);
                }
                return ctx.fuzzChild(resource, () -> ((Resource)resource).hasMeta(), () -> ((Resource)resource).getMeta());
            }).toList();
            return FuzzingLogEntry.parent(MessageFormat.format("Randomly add {0} BundleEntryComponents to Bundle {1}", amount, bundle.getId()), children);
        });
        return mutators;
    }
}

