/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.BodyStructure;

public class BodyStructureMutatorProvider
extends BaseDomainResourceMutatorProvider<BodyStructure> {
    public BodyStructureMutatorProvider() {
        super(BodyStructureMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<BodyStructure>> createMutators() {
        LinkedList<FuzzingMutator<BodyStructure>> mutators = new LinkedList<FuzzingMutator<BodyStructure>>();
        mutators.add((ctx, bs) -> ctx.fuzzChildTypes(bs.getClass(), bs.getIdentifier(), () -> ((BodyStructure)bs).getIdentifierFirstRep()));
        mutators.add((ctx, bs) -> ctx.fuzzChildTypes(bs.getClass(), bs.getImage(), () -> ((BodyStructure)bs).getImageFirstRep()));
        mutators.add((ctx, bs) -> ctx.fuzzChildTypes(bs.getClass(), bs.getLocationQualifier(), () -> ((BodyStructure)bs).getLocationQualifierFirstRep()));
        mutators.add((ctx, bs) -> ctx.fuzzChild(bs, () -> ((BodyStructure)bs).hasDescription(), () -> ((BodyStructure)bs).getDescriptionElement()));
        mutators.add((ctx, bs) -> ctx.fuzzChild(bs, () -> ((BodyStructure)bs).hasLocation(), () -> ((BodyStructure)bs).getLocation()));
        mutators.add((ctx, bs) -> ctx.fuzzChild(bs, () -> ((BodyStructure)bs).hasActive(), () -> ((BodyStructure)bs).getActiveElement()));
        mutators.add((ctx, bs) -> ctx.fuzzChild(bs, () -> ((BodyStructure)bs).hasMorphology(), () -> ((BodyStructure)bs).getMorphology()));
        mutators.add((ctx, bs) -> ctx.fuzzChild(bs, () -> ((BodyStructure)bs).hasPatient(), () -> ((BodyStructure)bs).getPatient()));
        return mutators;
    }
}

