/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveStringTypes;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeFuzzingResponse;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseResourceMutatorProvider;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.Binary;

public class BinaryMutatorProvider
extends BaseResourceMutatorProvider<Binary> {
    public BinaryMutatorProvider() {
        super(BinaryMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Binary>> createMutators() {
        LinkedList<FuzzingMutator<Binary>> mutators = new LinkedList<FuzzingMutator<Binary>>();
        mutators.add((ctx, binary) -> ctx.fuzzChild(binary, () -> ((Binary)binary).hasContentType(), () -> ((Binary)binary).getContentTypeElement()));
        mutators.add((ctx, binary) -> ctx.fuzzChild(binary, () -> ((Binary)binary).hasSecurityContext(), () -> ((Binary)binary).getSecurityContext()));
        mutators.add((ctx, binary) -> {
            String operation;
            Base64BinaryType b64Data = binary.getDataElement();
            byte[] data = BinaryMutatorProvider.ensureNotNull(ctx.randomness(), b64Data.getValue());
            byte[] fdata = ctx.randomness().regexify(".{1,10}").getBytes();
            byte[] result = new byte[data.length + fdata.length];
            if (ctx.randomness().source().nextBoolean()) {
                operation = "Prepend";
                System.arraycopy(fdata, 0, result, 0, fdata.length);
                System.arraycopy(data, 0, result, fdata.length, data.length);
            } else {
                operation = "Append";
                System.arraycopy(data, 0, result, 0, data.length);
                System.arraycopy(fdata, 0, result, data.length, fdata.length);
            }
            b64Data.setValue(result);
            return FuzzingLogEntry.operation(MessageFormat.format("{0} random {1} bytes to Binary", operation, fdata.length));
        });
        mutators.add((ctx, binary) -> {
            Base64BinaryType b64Data = binary.getDataElement();
            String data = b64Data.getValueAsString();
            PrimitiveTypeFuzzingResponse<String> pfResponse = ctx.fuzzPrimitiveType("Fuzz Binary as plain String", PrimitiveStringTypes.TEXT, data);
            String fdata = BinaryMutatorProvider.ensureNotNull(ctx.randomness(), pfResponse.getFuzzedValue());
            b64Data.setValue(fdata.getBytes());
            return pfResponse.getLogEntry();
        });
        return mutators;
    }

    private static byte[] ensureNotNull(Randomness randomness, byte[] data) {
        if (data == null || data.length == 0) {
            data = randomness.regexify(".{1,20}").getBytes();
        }
        return data;
    }

    private static String ensureNotNull(Randomness randomness, String data) {
        if (data == null) {
            data = randomness.regexify(".{1,20}");
        }
        return data;
    }
}

