/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FhirResourceMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.r4.model.Resource;

public abstract class BaseResourceMutatorProvider<R extends Resource>
implements FhirResourceMutatorProvider<R> {
    private final List<FuzzingMutator<R>> mutators = BaseResourceMutatorProvider.createMutators();

    protected BaseResourceMutatorProvider(List<FuzzingMutator<R>> concreteMutators) {
        this.mutators.addAll(0, concreteMutators);
    }

    private static <R extends Resource> List<FuzzingMutator<R>> createMutators() {
        LinkedList<FuzzingMutator<R>> mutators = new LinkedList<FuzzingMutator<R>>();
        mutators.add((ctx, resource) -> ctx.fuzzIdElement(resource.getClass(), resource));
        mutators.add((ctx, resource) -> ctx.fuzzIdElement(resource.getClass(), resource));
        mutators.add((ctx, resource) -> ctx.fuzzChild(resource, resource.hasMeta(), () -> ((Resource)resource).getMeta()));
        mutators.add((ctx, resource) -> ctx.fuzzChild(resource, resource.hasLanguageElement(), () -> ((Resource)resource).getLanguageElement()));
        mutators.add((ctx, resource) -> ctx.fuzzChild(resource, resource.hasImplicitRulesElement(), () -> ((Resource)resource).getImplicitRulesElement()));
        return mutators;
    }

    @Override
    @Generated
    public List<FuzzingMutator<R>> getMutators() {
        return this.mutators;
    }
}

