/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseResourceMutatorProvider;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Resource;

public abstract class BaseDomainResourceMutatorProvider<R extends DomainResource>
extends BaseResourceMutatorProvider<R> {
    protected BaseDomainResourceMutatorProvider(List<FuzzingMutator<R>> concreteMutators) {
        super(BaseDomainResourceMutatorProvider.createMutators());
        this.getMutators().addAll(0, concreteMutators);
    }

    private static <R extends DomainResource> List<FuzzingMutator<R>> createMutators() {
        LinkedList<FuzzingMutator<R>> mutators = new LinkedList<FuzzingMutator<R>>();
        mutators.add((ctx, dr) -> ctx.fuzzChildTypes(dr.getClass(), dr.getExtension(), () -> ((DomainResource)dr).addExtension()));
        mutators.add((ctx, dr) -> ctx.fuzzChildTypes(dr.getClass(), dr.getModifierExtension(), () -> ((DomainResource)dr).addModifierExtension()));
        mutators.add((ctx, dr) -> ctx.fuzzChild(dr, dr.hasText(), () -> ((DomainResource)dr).getText()));
        mutators.add((ctx, dr) -> ctx.fuzzChildResources(dr.getClass(), dr.getContained()));
        mutators.add((ctx, dr) -> {
            Resource r = ctx.randomness().fhir().createResource();
            dr.addContained(r);
            String message = MessageFormat.format("Add random Resource {0} to {1} with ID {2}", r.getClass().getSimpleName(), dr.getClass().getSimpleName(), dr.getId());
            return FuzzingLogEntry.parent(message, ctx.fuzzChild(dr.getClass(), r));
        });
        return mutators;
    }
}

