/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.AuditEvent;

public class AuditEventMutatorProvider
extends BaseDomainResourceMutatorProvider<AuditEvent> {
    public AuditEventMutatorProvider() {
        super(AuditEventMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<AuditEvent>> createMutators() {
        LinkedList<FuzzingMutator<AuditEvent>> mutators = new LinkedList<FuzzingMutator<AuditEvent>>();
        mutators.add((ctx, ae) -> ctx.fuzzChildTypes(ae.getClass(), ae.getPurposeOfEvent(), () -> ((AuditEvent)ae).getPurposeOfEventFirstRep()));
        mutators.add((ctx, ae) -> ctx.fuzzChildTypes(ae.getClass(), ae.getSubtype(), () -> ((AuditEvent)ae).getSubtypeFirstRep()));
        mutators.add((ctx, ae) -> ctx.fuzzChild(ae, () -> ((AuditEvent)ae).hasType(), () -> ((AuditEvent)ae).getType()));
        mutators.add((ctx, ae) -> ctx.fuzzChild(ae, () -> ((AuditEvent)ae).hasPeriod(), () -> ((AuditEvent)ae).getPeriod()));
        mutators.add((ctx, ae) -> ctx.fuzzChild(ae, () -> ((AuditEvent)ae).hasOutcome(), () -> ((AuditEvent)ae).getOutcomeDescElement()));
        mutators.add((ctx, ae) -> ctx.fuzzChild(ae, () -> ((AuditEvent)ae).hasRecorded(), () -> ((AuditEvent)ae).getRecordedElement()));
        mutators.add((ctx, ae) -> {
            AuditEvent.AuditEventOutcome outcome = ae.getOutcome();
            AuditEvent.AuditEventOutcome foutcome = ctx.randomness().chooseRandomFromEnum(AuditEvent.AuditEventOutcome.class, outcome);
            ae.setOutcome(foutcome);
            return FuzzingLogEntry.operation(MessageFormat.format("Change AuditEventOutcome of AuditEvent {0}: {1} -> {2}", ae.getId(), outcome, foutcome));
        });
        mutators.add((ctx, ae) -> {
            AuditEvent.AuditEventAction action = ae.getAction();
            AuditEvent.AuditEventAction faction = ctx.randomness().chooseRandomFromEnum(AuditEvent.AuditEventAction.class, action);
            ae.setAction(faction);
            return FuzzingLogEntry.operation(MessageFormat.format("Change AuditEventAction of AuditEvent {0}: {1} -> {2}", ae.getId(), action, faction));
        });
        return mutators;
    }
}

