/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Appointment;

public class AppointmentMutatorProvider
extends BaseDomainResourceMutatorProvider<Appointment> {
    public AppointmentMutatorProvider() {
        super(AppointmentMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Appointment>> createMutators() {
        LinkedList<FuzzingMutator<Appointment>> mutators = new LinkedList<FuzzingMutator<Appointment>>();
        mutators.add((ctx, apt) -> ctx.fuzzChildTypes(apt.getClass(), apt.getIdentifier(), () -> ((Appointment)apt).getIdentifierFirstRep()));
        mutators.add((ctx, apt) -> ctx.fuzzChildTypes(apt.getClass(), apt.getServiceType(), () -> ((Appointment)apt).getServiceTypeFirstRep()));
        mutators.add((ctx, apt) -> ctx.fuzzChildTypes(apt.getClass(), apt.getServiceCategory(), () -> ((Appointment)apt).getServiceCategoryFirstRep()));
        mutators.add((ctx, apt) -> ctx.fuzzChildTypes(apt.getClass(), apt.getBasedOn(), () -> ((Appointment)apt).getBasedOnFirstRep()));
        mutators.add((ctx, apt) -> ctx.fuzzChildTypes(apt.getClass(), apt.getReasonCode(), () -> ((Appointment)apt).getReasonCodeFirstRep()));
        mutators.add((ctx, apt) -> ctx.fuzzChildTypes(apt.getClass(), apt.getReasonReference(), () -> ((Appointment)apt).getReasonReferenceFirstRep()));
        mutators.add((ctx, apt) -> ctx.fuzzChildTypes(apt.getClass(), apt.getRequestedPeriod(), () -> ((Appointment)apt).getRequestedPeriodFirstRep()));
        mutators.add((ctx, apt) -> ctx.fuzzChildTypes(apt.getClass(), apt.getSpecialty(), () -> ((Appointment)apt).getSpecialtyFirstRep()));
        mutators.add((ctx, apt) -> ctx.fuzzChildTypes(apt.getClass(), apt.getSlot(), () -> ((Appointment)apt).getSlotFirstRep()));
        mutators.add((ctx, apt) -> ctx.fuzzChildTypes(apt.getClass(), apt.getSupportingInformation(), () -> ((Appointment)apt).getSupportingInformationFirstRep()));
        mutators.add((ctx, apt) -> ctx.fuzzChild(apt, () -> ((Appointment)apt).hasPriority(), () -> ((Appointment)apt).getPriorityElement()));
        mutators.add((ctx, apt) -> ctx.fuzzChild(apt, () -> ((Appointment)apt).hasCreated(), () -> ((Appointment)apt).getCreatedElement()));
        mutators.add((ctx, apt) -> ctx.fuzzChild(apt, () -> ((Appointment)apt).hasAppointmentType(), () -> ((Appointment)apt).getAppointmentType()));
        mutators.add((ctx, apt) -> ctx.fuzzChild(apt, () -> ((Appointment)apt).hasCancelationReason(), () -> ((Appointment)apt).getCancelationReason()));
        mutators.add((ctx, apt) -> ctx.fuzzChild(apt, () -> ((Appointment)apt).hasComment(), () -> ((Appointment)apt).getCommentElement()));
        mutators.add((ctx, apt) -> ctx.fuzzChild(apt, () -> ((Appointment)apt).hasDescription(), () -> ((Appointment)apt).getDescriptionElement()));
        mutators.add((ctx, apt) -> ctx.fuzzChild(apt, () -> ((Appointment)apt).hasEnd(), () -> ((Appointment)apt).getEndElement()));
        mutators.add((ctx, apt) -> ctx.fuzzChild(apt, () -> ((Appointment)apt).hasMinutesDuration(), () -> ((Appointment)apt).getMinutesDurationElement()));
        mutators.add((ctx, apt) -> ctx.fuzzChild(apt, () -> ((Appointment)apt).hasPatientInstruction(), () -> ((Appointment)apt).getPatientInstructionElement()));
        return mutators;
    }
}

