/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.Type;

public class AllergyIntoleranceMutatorProvider
extends BaseDomainResourceMutatorProvider<AllergyIntolerance> {
    public AllergyIntoleranceMutatorProvider() {
        super(AllergyIntoleranceMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<AllergyIntolerance>> createMutators() {
        LinkedList<FuzzingMutator<AllergyIntolerance>> mutators = new LinkedList<FuzzingMutator<AllergyIntolerance>>();
        mutators.add((ctx, ai) -> ctx.fuzzChildTypes(ai.getClass(), ai.getIdentifier(), () -> ((AllergyIntolerance)ai).getIdentifierFirstRep()));
        mutators.add((ctx, ai) -> ctx.fuzzChildTypes(ai.getClass(), ai.getNote(), () -> ((AllergyIntolerance)ai).getNoteFirstRep()));
        mutators.add((ctx, ai) -> ctx.fuzzChild(ai, () -> ((AllergyIntolerance)ai).hasEncounter(), () -> ((AllergyIntolerance)ai).getEncounter()));
        mutators.add((ctx, ai) -> ctx.fuzzChild(ai, () -> ((AllergyIntolerance)ai).hasAsserter(), () -> ((AllergyIntolerance)ai).getAsserter()));
        mutators.add((ctx, ai) -> ctx.fuzzChild(ai, () -> ((AllergyIntolerance)ai).hasClinicalStatus(), () -> ((AllergyIntolerance)ai).getClinicalStatus()));
        mutators.add((ctx, ai) -> ctx.fuzzChild(ai, () -> ((AllergyIntolerance)ai).hasCode(), () -> ((AllergyIntolerance)ai).getCode()));
        mutators.add((ctx, ai) -> ctx.fuzzChild(ai, () -> ((AllergyIntolerance)ai).hasLastOccurrence(), () -> ((AllergyIntolerance)ai).getLastOccurrenceElement()));
        mutators.add((ctx, ai) -> ctx.fuzzChild(ai, () -> ((AllergyIntolerance)ai).hasPatient(), () -> ((AllergyIntolerance)ai).getPatient()));
        mutators.add((ctx, ai) -> ctx.fuzzChild(ai, () -> ((AllergyIntolerance)ai).hasRecordedDate(), () -> ((AllergyIntolerance)ai).getRecordedDateElement()));
        mutators.add((ctx, ai) -> ctx.fuzzChild(ai, () -> ((AllergyIntolerance)ai).hasRecorder(), () -> ((AllergyIntolerance)ai).getRecorder()));
        mutators.add((ctx, ai) -> ctx.fuzzChild(ai, () -> ((AllergyIntolerance)ai).hasVerificationStatus(), () -> ((AllergyIntolerance)ai).getVerificationStatus()));
        mutators.add((ctx, ai) -> {
            if (ai.hasOnset()) {
                return ctx.fuzzChild(ai, true, () -> ((AllergyIntolerance)ai).getOnset());
            }
            Supplier<Type> supplier = ctx.randomness().chooseRandomElement(List.of(() -> ((AllergyIntolerance)ai).getOnsetAge(), () -> ((AllergyIntolerance)ai).getOnsetPeriod(), () -> ((AllergyIntolerance)ai).getOnsetRange(), () -> ((AllergyIntolerance)ai).getOnsetDateTimeType(), () -> ((AllergyIntolerance)ai).getOnsetStringType()));
            return ctx.fuzzChild(ai, () -> ((AllergyIntolerance)ai).hasOnset(), supplier);
        });
        return mutators;
    }
}

