/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources;

import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BaseDomainResourceMutatorProvider;
import java.util.LinkedList;
import java.util.List;
import org.hl7.fhir.r4.model.Account;

public class AccountMutatorProvider
extends BaseDomainResourceMutatorProvider<Account> {
    public AccountMutatorProvider() {
        super(AccountMutatorProvider.createMutators());
    }

    private static List<FuzzingMutator<Account>> createMutators() {
        LinkedList<FuzzingMutator<Account>> mutators = new LinkedList<FuzzingMutator<Account>>();
        mutators.add((ctx, acc) -> ctx.fuzzChildTypes(acc.getClass(), acc.getIdentifier(), () -> ((Account)acc).getIdentifierFirstRep()));
        mutators.add((ctx, acc) -> ctx.fuzzChildTypes(acc.getClass(), acc.getSubject(), () -> ((Account)acc).getSubjectFirstRep()));
        mutators.add((ctx, acc) -> ctx.fuzzChild(acc, () -> ((Account)acc).hasNameElement(), () -> ((Account)acc).getNameElement()));
        mutators.add((ctx, acc) -> ctx.fuzzChild(acc, () -> ((Account)acc).hasType(), () -> ((Account)acc).getType()));
        mutators.add((ctx, acc) -> ctx.fuzzChild(acc, () -> ((Account)acc).hasDescription(), () -> ((Account)acc).getDescriptionElement()));
        mutators.add((ctx, acc) -> ctx.fuzzChild(acc, () -> ((Account)acc).hasOwner(), () -> ((Account)acc).getOwner()));
        mutators.add((ctx, acc) -> ctx.fuzzChild(acc, () -> ((Account)acc).hasPartOf(), () -> ((Account)acc).getPartOf()));
        mutators.add((ctx, acc) -> ctx.fuzzChild(acc, () -> ((Account)acc).hasServicePeriod(), () -> ((Account)acc).getServicePeriod()));
        mutators.add((ctx, acc) -> {
            Account.CoverageComponent cov = acc.getCoverageFirstRep();
            return ctx.fuzzChild(acc.getClass(), cov.getCoverageTarget());
        });
        mutators.add((ctx, acc) -> {
            Account.CoverageComponent cov = acc.getCoverageFirstRep();
            return ctx.fuzzChild(acc, () -> ((Account.CoverageComponent)cov).hasCoverage(), () -> ((Account.CoverageComponent)cov).getCoverage());
        });
        return mutators;
    }
}

