/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.primitive;

import de.gematik.bbriccs.fhir.fuzzing.PrimitiveMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeFuzzingResponse;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimitiveUriMutatorProvider
implements PrimitiveMutatorProvider<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrimitiveUriMutatorProvider.class);
    private static final String HTTP_SCHEMA = "http://";
    private static final String HTTPS_SCHEMA = "https://";
    private final List<PrimitiveTypeMutator<String>> mutators = PrimitiveUriMutatorProvider.createMutators();

    private static List<PrimitiveTypeMutator<String>> createMutators() {
        LinkedList<PrimitiveTypeMutator<String>> mutators = new LinkedList<PrimitiveTypeMutator<String>>();
        mutators.add((ctx, input) -> {
            input = PrimitiveUriMutatorProvider.ensureNotNull(ctx.randomness(), input);
            String finput = MessageFormat.format("{0}|{1}", input, ctx.randomness().version());
            return PrimitiveTypeFuzzingResponse.response(finput, FuzzingLogEntry.operation(MessageFormat.format("Append random Version: {0} -> {1}", input, finput)));
        });
        mutators.add((ctx, input) -> {
            input = PrimitiveUriMutatorProvider.ensureNotNull(ctx.randomness(), input);
            String appendix = ctx.randomness().regexify("[A-Za-z0-9-+_/(){}\\[\\]|\"'$%?#!\u00a7&=@]{1,20}");
            String finput = MessageFormat.format("{0}|{1}", input, appendix);
            return PrimitiveTypeFuzzingResponse.response(finput, FuzzingLogEntry.operation(MessageFormat.format("Append random String instead of Version: {0} -> {1}", input, finput)));
        });
        mutators.add((ctx, input) -> {
            input = PrimitiveUriMutatorProvider.ensureNotNull(ctx.randomness(), input);
            String appendix = ctx.randomness().regexify("[|\"'()\\{}\\[\\]]{1,50}");
            String finput = MessageFormat.format("{0}|{1}", input, appendix);
            return PrimitiveTypeFuzzingResponse.response(finput, FuzzingLogEntry.operation(MessageFormat.format("Append random Brackets instead of Version: {0} -> {1}", input, finput)));
        });
        mutators.add((ctx, input) -> {
            String originalUrl = input;
            input = PrimitiveUriMutatorProvider.ensureNotNull(ctx.randomness(), input);
            String fids = input.startsWith(HTTP_SCHEMA) ? input.replace(HTTP_SCHEMA, HTTPS_SCHEMA) : (input.startsWith(HTTPS_SCHEMA) ? input.replace(HTTPS_SCHEMA, HTTP_SCHEMA) : ctx.randomness().url());
            return PrimitiveTypeFuzzingResponse.response(fids, FuzzingLogEntry.operation(MessageFormat.format("Changed URL: {0} -> {1}", originalUrl, fids)));
        });
        return mutators;
    }

    private static String ensureNotNull(Randomness randomness, @Nullable String uri) {
        if (uri == null) {
            return randomness.url();
        }
        return uri;
    }

    @Override
    @Generated
    public List<PrimitiveTypeMutator<String>> getMutators() {
        return this.mutators;
    }
}

