/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.primitive;

import de.gematik.bbriccs.fhir.fuzzing.PrimitiveMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeFuzzingResponse;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import lombok.Generated;

public class PlainTextMutatorProvider
implements PrimitiveMutatorProvider<String> {
    private final List<PrimitiveTypeMutator<String>> mutators = PlainTextMutatorProvider.createMutators();

    private static List<PrimitiveTypeMutator<String>> createMutators() {
        LinkedList<PrimitiveTypeMutator<String>> mutators = new LinkedList<PrimitiveTypeMutator<String>>();
        mutators.add((ctx, text) -> {
            String otext = PlainTextMutatorProvider.ensureNotNull(ctx.randomness(), text);
            String reversed = new StringBuilder(otext).reverse().toString();
            return PrimitiveTypeFuzzingResponse.response(reversed, FuzzingLogEntry.operation(MessageFormat.format("Reverse Text: ''{0}'' -> ''{1}''", text, reversed)));
        });
        mutators.add((ctx, text) -> {
            text = PlainTextMutatorProvider.ensureNotNull(ctx.randomness(), text);
            String duplicated = text + text;
            return PrimitiveTypeFuzzingResponse.response(duplicated, FuzzingLogEntry.operation(MessageFormat.format("Duplicate Text: ''{0}'' -> ''{1}''", text, duplicated)));
        });
        mutators.add((ctx, text) -> {
            text = PlainTextMutatorProvider.ensureNotNull(ctx.randomness(), text);
            String empty = " ";
            return PrimitiveTypeFuzzingResponse.response(" ", FuzzingLogEntry.operation(MessageFormat.format("Make empty Text: {0} -> ''{1}''", text, " ")));
        });
        mutators.add((ctx, text) -> {
            int spaces = ctx.randomness().source().nextInt(1, 5);
            StringBuilder builder = new StringBuilder();
            IntStream.range(0, spaces).forEach(i -> builder.append(ctx.randomness().chooseRandomElement(List.of(" ", "\t", "\n"))));
            String ftext = builder.toString();
            return PrimitiveTypeFuzzingResponse.response(ftext, FuzzingLogEntry.operation(MessageFormat.format("Make empty Text with random white spaces: {0} -> ''{1}''", text, ftext)));
        });
        return mutators;
    }

    private static String ensureNotNull(Randomness randomness, String text) {
        if (text == null || text.isEmpty() || text.isBlank()) {
            return randomness.regexify("[A-Za-z]{2,50}");
        }
        return text;
    }

    @Override
    @Generated
    public List<PrimitiveTypeMutator<String>> getMutators() {
        return this.mutators;
    }
}

