/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.primitive;

import de.gematik.bbriccs.fhir.fuzzing.PrimitiveMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveStringTypes;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;

public class CodeMutatorProvider
implements PrimitiveMutatorProvider<String> {
    private final List<PrimitiveTypeMutator<String>> mutators = CodeMutatorProvider.createMutators();

    private static List<PrimitiveTypeMutator<String>> createMutators() {
        LinkedList<PrimitiveTypeMutator<String>> mutators = new LinkedList<PrimitiveTypeMutator<String>>();
        mutators.add((ctx, code) -> ctx.fuzzPrimitiveType(MessageFormat.format("Fuzz Code {0} as plain text", code), PrimitiveStringTypes.TEXT, CodeMutatorProvider.ensureNotNull(ctx.randomness(), code)));
        return mutators;
    }

    private static String ensureNotNull(Randomness randomness, @Nullable String code) {
        if (code == null) {
            return randomness.regexify("[A-Za-z]{2,5}");
        }
        return code;
    }

    @Override
    @Generated
    public List<PrimitiveTypeMutator<String>> getMutators() {
        return this.mutators;
    }
}

