/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.log;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntryType;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RootFuzzingLogEntry
extends FuzzingLogEntry {
    private long mutations;
    private long added;
    private long noops;
    private List<FuzzingLogEntry> children = new LinkedList<FuzzingLogEntry>();

    RootFuzzingLogEntry(String message, List<FuzzingLogEntry> children) {
        this.setType(FuzzingLogEntryType.ROOT);
        this.setMessage(message);
        this.addChildren(children);
    }

    private void addChildren(List<FuzzingLogEntry> children) {
        this.children.addAll(children);
        long directMutations = children.stream().map(FuzzingLogEntry::getType).filter(t -> t.equals((Object)FuzzingLogEntryType.MUTATION)).count();
        long directAdditions = children.stream().map(FuzzingLogEntry::getType).filter(t -> t.equals((Object)FuzzingLogEntryType.ADD)).count();
        long directNoops = children.stream().map(FuzzingLogEntry::getType).filter(t -> t.equals((Object)FuzzingLogEntryType.NOOP)).count();
        this.setMutations(directMutations + children.stream().filter(fle -> fle.getClass().equals(RootFuzzingLogEntry.class)).map(fle -> ((RootFuzzingLogEntry)fle).getMutations()).reduce(0L, Long::sum));
        this.setAdded(directAdditions + children.stream().filter(fle -> fle.getClass().equals(RootFuzzingLogEntry.class)).map(fle -> ((RootFuzzingLogEntry)fle).getAdded()).reduce(0L, Long::sum));
        this.setNoops(directNoops + children.stream().filter(fle -> fle.getClass().equals(RootFuzzingLogEntry.class)).map(fle -> ((RootFuzzingLogEntry)fle).getNoops()).reduce(0L, Long::sum));
    }

    @Generated
    public long getMutations() {
        return this.mutations;
    }

    @Generated
    public long getAdded() {
        return this.added;
    }

    @Generated
    public long getNoops() {
        return this.noops;
    }

    @Generated
    public List<FuzzingLogEntry> getChildren() {
        return this.children;
    }

    @Generated
    public void setMutations(long mutations) {
        this.mutations = mutations;
    }

    @Generated
    public void setAdded(long added) {
        this.added = added;
    }

    @Generated
    public void setNoops(long noops) {
        this.noops = noops;
    }

    @Generated
    public void setChildren(List<FuzzingLogEntry> children) {
        this.children = children;
    }

    @Override
    @Generated
    public String toString() {
        return "RootFuzzingLogEntry(mutations=" + this.getMutations() + ", added=" + this.getAdded() + ", noops=" + this.getNoops() + ", children=" + this.getChildren() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RootFuzzingLogEntry)) {
            return false;
        }
        RootFuzzingLogEntry other = (RootFuzzingLogEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMutations() != other.getMutations()) {
            return false;
        }
        if (this.getAdded() != other.getAdded()) {
            return false;
        }
        if (this.getNoops() != other.getNoops()) {
            return false;
        }
        List<FuzzingLogEntry> this$children = this.getChildren();
        List<FuzzingLogEntry> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RootFuzzingLogEntry;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $mutations = this.getMutations();
        result = result * 59 + (int)($mutations >>> 32 ^ $mutations);
        long $added = this.getAdded();
        result = result * 59 + (int)($added >>> 32 ^ $added);
        long $noops = this.getNoops();
        result = result * 59 + (int)($noops >>> 32 ^ $noops);
        List<FuzzingLogEntry> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }
}

