/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.log;

import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.RootFuzzingLogEntry;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;

public class FuzzingSessionLogbook {
    private LocalDateTime started;
    private Duration duration;
    private long mutations;
    private long added;
    private long noops;
    private RootFuzzingLogEntry sessionLog;

    public static FuzzingSessionLogbook logSession(String message, Duration duration, List<FuzzingLogEntry> children) {
        RootFuzzingLogEntry parentLog = FuzzingLogEntry.parent(message, children);
        Long mutations = children.stream().filter(cfle -> cfle.getClass().equals(RootFuzzingLogEntry.class)).map(cfle -> ((RootFuzzingLogEntry)cfle).getMutations()).reduce(0L, Long::sum);
        Long added = children.stream().filter(cfle -> cfle.getClass().equals(RootFuzzingLogEntry.class)).map(cfle -> ((RootFuzzingLogEntry)cfle).getAdded()).reduce(0L, Long::sum);
        Long noops = children.stream().filter(cfle -> cfle.getClass().equals(RootFuzzingLogEntry.class)).map(cfle -> ((RootFuzzingLogEntry)cfle).getNoops()).reduce(0L, Long::sum);
        return new FuzzingSessionLogbook(LocalDateTime.now(), duration, mutations, added, noops, parentLog);
    }

    public long changes() {
        return this.mutations + this.added;
    }

    @Generated
    public LocalDateTime getStarted() {
        return this.started;
    }

    @Generated
    public Duration getDuration() {
        return this.duration;
    }

    @Generated
    public long getMutations() {
        return this.mutations;
    }

    @Generated
    public long getAdded() {
        return this.added;
    }

    @Generated
    public long getNoops() {
        return this.noops;
    }

    @Generated
    public RootFuzzingLogEntry getSessionLog() {
        return this.sessionLog;
    }

    @Generated
    public void setStarted(LocalDateTime started) {
        this.started = started;
    }

    @Generated
    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    @Generated
    public void setMutations(long mutations) {
        this.mutations = mutations;
    }

    @Generated
    public void setAdded(long added) {
        this.added = added;
    }

    @Generated
    public void setNoops(long noops) {
        this.noops = noops;
    }

    @Generated
    public void setSessionLog(RootFuzzingLogEntry sessionLog) {
        this.sessionLog = sessionLog;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FuzzingSessionLogbook)) {
            return false;
        }
        FuzzingSessionLogbook other = (FuzzingSessionLogbook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMutations() != other.getMutations()) {
            return false;
        }
        if (this.getAdded() != other.getAdded()) {
            return false;
        }
        if (this.getNoops() != other.getNoops()) {
            return false;
        }
        LocalDateTime this$started = this.getStarted();
        LocalDateTime other$started = other.getStarted();
        if (this$started == null ? other$started != null : !((Object)this$started).equals(other$started)) {
            return false;
        }
        Duration this$duration = this.getDuration();
        Duration other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        RootFuzzingLogEntry this$sessionLog = this.getSessionLog();
        RootFuzzingLogEntry other$sessionLog = other.getSessionLog();
        return !(this$sessionLog == null ? other$sessionLog != null : !((Object)this$sessionLog).equals(other$sessionLog));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FuzzingSessionLogbook;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $mutations = this.getMutations();
        result = result * 59 + (int)($mutations >>> 32 ^ $mutations);
        long $added = this.getAdded();
        result = result * 59 + (int)($added >>> 32 ^ $added);
        long $noops = this.getNoops();
        result = result * 59 + (int)($noops >>> 32 ^ $noops);
        LocalDateTime $started = this.getStarted();
        result = result * 59 + ($started == null ? 43 : ((Object)$started).hashCode());
        Duration $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        RootFuzzingLogEntry $sessionLog = this.getSessionLog();
        result = result * 59 + ($sessionLog == null ? 43 : ((Object)$sessionLog).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FuzzingSessionLogbook(started=" + this.getStarted() + ", duration=" + this.getDuration() + ", mutations=" + this.getMutations() + ", added=" + this.getAdded() + ", noops=" + this.getNoops() + ", sessionLog=" + this.getSessionLog() + ")";
    }

    @Generated
    private FuzzingSessionLogbook() {
    }

    @Generated
    private FuzzingSessionLogbook(LocalDateTime started, Duration duration, long mutations, long added, long noops, RootFuzzingLogEntry sessionLog) {
        this.started = started;
        this.duration = duration;
        this.mutations = mutations;
        this.added = added;
        this.noops = noops;
        this.sessionLog = sessionLog;
    }
}

