/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.log;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.ErrorLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntryType;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.MutationFuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.NoOpFuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.RootFuzzingLogEntry;
import java.util.List;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public abstract class FuzzingLogEntry {
    private FuzzingLogEntryType type;
    private String message;

    public static RootFuzzingLogEntry parent(String message, FuzzingLogEntry child) {
        return FuzzingLogEntry.parent(message, List.of(child));
    }

    public static RootFuzzingLogEntry parent(String message, List<FuzzingLogEntry> children) {
        if (children.isEmpty()) {
            return FuzzingLogEntry.parent(message, FuzzingLogEntry.noop("no children"));
        }
        return new RootFuzzingLogEntry(message, children);
    }

    public static RootFuzzingLogEntry add(String message, FuzzingLogEntry child) {
        RootFuzzingLogEntry entry = new RootFuzzingLogEntry(message, List.of(child));
        entry.setType(FuzzingLogEntryType.ADD);
        return entry;
    }

    public static FuzzingLogEntry operation(String message) {
        return new MutationFuzzingLogEntry(message);
    }

    public static FuzzingLogEntry noop(String message) {
        return new NoOpFuzzingLogEntry("No Operation: " + message);
    }

    public static FuzzingLogEntry error(Throwable throwable) {
        return new ErrorLogEntry(throwable);
    }

    @Generated
    public FuzzingLogEntry() {
    }

    @Generated
    public FuzzingLogEntryType getType() {
        return this.type;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public void setType(FuzzingLogEntryType type) {
        this.type = type;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FuzzingLogEntry)) {
            return false;
        }
        FuzzingLogEntry other = (FuzzingLogEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FuzzingLogEntryType this$type = this.getType();
        FuzzingLogEntryType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FuzzingLogEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FuzzingLogEntryType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FuzzingLogEntry(type=" + this.getType() + ", message=" + this.getMessage() + ")";
    }
}

