/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl;

import de.gematik.bbriccs.fhir.fuzzing.FhirResourceMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingContext;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingEngine;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingMutator;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveStringTypes;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveType;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.exceptions.FuzzerException;
import de.gematik.bbriccs.fhir.fuzzing.impl.FuzzingContextImpl;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingSessionLogbook;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.primitive.CodeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.primitive.PlainTextMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.primitive.PrimitiveUriMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.AccountMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.AllergyIntoleranceMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.AppointmentMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.AppointmentResponseMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.AuditEventMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BinaryMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BiologicallyDerivedProductMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BodyStructureMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.BundleMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.CapabilityStatementMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.CarePlanMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.CareTeamMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.ChargeItemDefinitionMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.ChargeItemMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.ClaimMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.ClaimResponseMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.CommunicationMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.CommunicationRequestMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.CompositionMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.ConditionMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.ConsentMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.ContractMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.CoverageMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.DetectedIssueMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.DeviceMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.DocumentReferenceMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.EncounterMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.GoalMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.GroupMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.InsurancePlanMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.InvoiceMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.LocationMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.MediaMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.MedicationDispenseMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.MedicationMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.MedicationRequestMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.ObservationMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.OrganizationMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.ParametersMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.PatientMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.PersonMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.PractitionerMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.PractitionerRoleMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.ProvenanceMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.SpecimenMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.SubscriptionMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.SubstanceReferenceInformationMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.SupplyDeliveryMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.SupplyRequestMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.resources.TaskMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.AddressTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.AnnotationMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.AttachmentMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.Base64BinaryTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.BooleanTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.CanonicalTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.CodeTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.CodeableConceptTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.CodingMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.ContactDetailMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.ContactPointMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.ContributorMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.DataRequirementMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.DateTimeTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.DateTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.DecimalTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.DosageMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.ElementDefinitionMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.ExpressionMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.ExtensionTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.HumanNameTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.IdTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.IdentifierTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.InstantTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.IntegerTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.MarketingStatusMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.MetaTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.MoneyMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.NarrativeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.ParameterDefinitionMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.PeriodTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.PopulationMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.PositiveIntTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.ProdCharacteristicMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.ProductShelfLifeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.QuantityMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.RangeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.RatioMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.ReferenceTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.RelatedArtifactMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.SampleDataMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.SignatureMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.StringTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.SubstanceAmountMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.TimeTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.TimingTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.TriggerDefinitionMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.UnsignedIntTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.UriTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.UsageContextMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.impl.rnd.ProbabilityDiceImpl;
import de.gematik.bbriccs.fhir.fuzzing.impl.rnd.RandomnessImpl;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import lombok.Generated;
import org.hl7.fhir.r4.model.Account;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.Appointment;
import org.hl7.fhir.r4.model.AppointmentResponse;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.AuditEvent;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r4.model.BodyStructure;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.CarePlan;
import org.hl7.fhir.r4.model.CareTeam;
import org.hl7.fhir.r4.model.ChargeItem;
import org.hl7.fhir.r4.model.ChargeItemDefinition;
import org.hl7.fhir.r4.model.Claim;
import org.hl7.fhir.r4.model.ClaimResponse;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Communication;
import org.hl7.fhir.r4.model.CommunicationRequest;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Consent;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Contract;
import org.hl7.fhir.r4.model.Contributor;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Goal;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.InsurancePlan;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Invoice;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.MarketingStatus;
import org.hl7.fhir.r4.model.Media;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.ParameterDefinition;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Person;
import org.hl7.fhir.r4.model.Population;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.ProdCharacteristic;
import org.hl7.fhir.r4.model.ProductShelfLife;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Ratio;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.SampledData;
import org.hl7.fhir.r4.model.Signature;
import org.hl7.fhir.r4.model.Specimen;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r4.model.SubstanceAmount;
import org.hl7.fhir.r4.model.SubstanceReferenceInformation;
import org.hl7.fhir.r4.model.SupplyDelivery;
import org.hl7.fhir.r4.model.SupplyRequest;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.TriggerDefinition;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UsageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuzzingEngineImpl
implements FuzzingEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FuzzingEngineImpl.class);
    private final List<FuzzingSessionLogbook> fuzzingSessionHistory;
    private final FuzzingContext ctx;

    private FuzzingEngineImpl(FuzzingContext ctx) {
        this.ctx = ctx;
        this.fuzzingSessionHistory = new LinkedList<FuzzingSessionLogbook>();
    }

    @Override
    public <R extends Resource> FuzzingSessionLogbook fuzz(R resource) {
        return this.fuzz(resource, 0);
    }

    private <R extends Resource> FuzzingSessionLogbook fuzz(R resource, int recursionDepth) {
        String message = MessageFormat.format("Start Resource Fuzzer for {0} with ID {1}", resource.getClass().getSimpleName(), resource.getId());
        log.info(message);
        Instant start = Instant.now();
        List<FuzzingLogEntry> entry = this.ctx.startFuzzingSession(resource);
        Instant finish = Instant.now();
        Duration duration = Duration.between(start, finish);
        FuzzingSessionLogbook sessionLog = FuzzingSessionLogbook.logSession(message, duration, entry);
        this.fuzzingSessionHistory.add(0, sessionLog);
        if (sessionLog.changes() == 0L && recursionDepth < 10) {
            log.info("recursively repeat fuzzing iteration {}", (Object)recursionDepth);
            FuzzingSessionLogbook rsl = this.fuzz(resource, recursionDepth + 1);
            List<FuzzingLogEntry> rslEntries = rsl.getSessionLog().getChildren();
            ArrayList<FuzzingLogEntry> completeLog = new ArrayList<FuzzingLogEntry>(rslEntries.size() + entry.size());
            completeLog.addAll(rslEntries);
            completeLog.addAll(entry);
            return FuzzingSessionLogbook.logSession(message, rsl.getDuration().plus(sessionLog.getDuration()), completeLog);
        }
        log.info("Finish Fuzzing Session for {} after {}: added {} / mutated {}", new Object[]{resource.getClass().getSimpleName(), duration, sessionLog.getAdded(), sessionLog.getMutations()});
        return sessionLog;
    }

    @Override
    public FuzzingSessionLogbook getLastSessionLog() {
        if (this.fuzzingSessionHistory.isEmpty()) {
            throw new FuzzerException(MessageFormat.format("no sessions started so far", new Object[0]));
        }
        return this.fuzzingSessionHistory.get(0);
    }

    @Override
    public List<FuzzingSessionLogbook> getSessionHistory() {
        return this.fuzzingSessionHistory;
    }

    @Override
    public FuzzingContext getContext() {
        return this.ctx;
    }

    public static Builder builder(double probability) {
        return FuzzingEngineImpl.builder(new SecureRandom(), probability);
    }

    public static Builder builder(Random rnd, double probability) {
        ProbabilityDiceImpl pdMutator = new ProbabilityDiceImpl(rnd, probability);
        ProbabilityDiceImpl pdChildResources = new ProbabilityDiceImpl(rnd, probability);
        RandomnessImpl randomness = new RandomnessImpl(rnd, pdMutator, pdChildResources);
        return FuzzingEngineImpl.builder(randomness);
    }

    public static Builder builder(Randomness randomness) {
        FuzzingContextImpl ctx = new FuzzingContextImpl(randomness);
        return new Builder(ctx);
    }

    public static class Builder {
        private final FuzzingContextImpl ctx;

        private Builder(FuzzingContextImpl ctx) {
            this.ctx = ctx;
        }

        public Builder withDefaultFuzzers() {
            return this.registerResourceFuzzer(Account.class, AccountMutatorProvider::new).registerResourceFuzzer(AllergyIntolerance.class, AllergyIntoleranceMutatorProvider::new).registerResourceFuzzer(Appointment.class, AppointmentMutatorProvider::new).registerResourceFuzzer(AppointmentResponse.class, AppointmentResponseMutatorProvider::new).registerResourceFuzzer(AuditEvent.class, AuditEventMutatorProvider::new).registerResourceFuzzer(Binary.class, BinaryMutatorProvider::new).registerResourceFuzzer(BiologicallyDerivedProduct.class, BiologicallyDerivedProductMutatorProvider::new).registerResourceFuzzer(BodyStructure.class, BodyStructureMutatorProvider::new).registerResourceFuzzer(Bundle.class, BundleMutatorProvider::new).registerResourceFuzzer(CapabilityStatement.class, CapabilityStatementMutatorProvider::new).registerResourceFuzzer(CarePlan.class, CarePlanMutatorProvider::new).registerResourceFuzzer(CareTeam.class, CareTeamMutatorProvider::new).registerResourceFuzzer(ChargeItem.class, ChargeItemMutatorProvider::new).registerResourceFuzzer(ChargeItemDefinition.class, ChargeItemDefinitionMutatorProvider::new).registerResourceFuzzer(Claim.class, ClaimMutatorProvider::new).registerResourceFuzzer(ClaimResponse.class, ClaimResponseMutatorProvider::new).registerResourceFuzzer(Composition.class, CompositionMutatorProvider::new).registerResourceFuzzer(Condition.class, ConditionMutatorProvider::new).registerResourceFuzzer(Communication.class, CommunicationMutatorProvider::new).registerResourceFuzzer(CommunicationRequest.class, CommunicationRequestMutatorProvider::new).registerResourceFuzzer(Consent.class, ConsentMutatorProvider::new).registerResourceFuzzer(Contract.class, ContractMutatorProvider::new).registerResourceFuzzer(Coverage.class, CoverageMutatorProvider::new).registerResourceFuzzer(DetectedIssue.class, DetectedIssueMutatorProvider::new).registerResourceFuzzer(Device.class, DeviceMutatorProvider::new).registerResourceFuzzer(DocumentReference.class, DocumentReferenceMutatorProvider::new).registerResourceFuzzer(Encounter.class, EncounterMutatorProvider::new).registerResourceFuzzer(Goal.class, GoalMutatorProvider::new).registerResourceFuzzer(Group.class, GroupMutatorProvider::new).registerResourceFuzzer(InsurancePlan.class, InsurancePlanMutatorProvider::new).registerResourceFuzzer(Invoice.class, InvoiceMutatorProvider::new).registerResourceFuzzer(Location.class, LocationMutatorProvider::new).registerResourceFuzzer(Media.class, MediaMutatorProvider::new).registerResourceFuzzer(Medication.class, MedicationMutatorProvider::new).registerResourceFuzzer(MedicationDispense.class, MedicationDispenseMutatorProvider::new).registerResourceFuzzer(MedicationRequest.class, MedicationRequestMutatorProvider::new).registerResourceFuzzer(Observation.class, ObservationMutatorProvider::new).registerResourceFuzzer(Organization.class, OrganizationMutatorProvider::new).registerResourceFuzzer(Parameters.class, ParametersMutatorProvider::new).registerResourceFuzzer(Patient.class, PatientMutatorProvider::new).registerResourceFuzzer(Person.class, PersonMutatorProvider::new).registerResourceFuzzer(Practitioner.class, PractitionerMutatorProvider::new).registerResourceFuzzer(Provenance.class, ProvenanceMutatorProvider::new).registerResourceFuzzer(PractitionerRole.class, PractitionerRoleMutatorProvider::new).registerResourceFuzzer(Specimen.class, SpecimenMutatorProvider::new).registerResourceFuzzer(Subscription.class, SubscriptionMutatorProvider::new).registerResourceFuzzer(SubstanceReferenceInformation.class, SubstanceReferenceInformationMutatorProvider::new).registerResourceFuzzer(SupplyDelivery.class, SupplyDeliveryMutatorProvider::new).registerResourceFuzzer(SupplyRequest.class, SupplyRequestMutatorProvider::new).registerResourceFuzzer(Task.class, TaskMutatorProvider::new).registerTypeFuzzer(Address.class, AddressTypeMutatorProvider::new).registerTypeFuzzer(Annotation.class, AnnotationMutatorProvider::new).registerTypeFuzzer(Attachment.class, AttachmentMutatorProvider::new).registerTypeFuzzer(Base64BinaryType.class, Base64BinaryTypeMutatorProvider::new).registerTypeFuzzer(BooleanType.class, BooleanTypeMutatorProvider::new).registerTypeFuzzer(CanonicalType.class, CanonicalTypeMutatorProvider::new).registerTypeFuzzer(CodeType.class, CodeTypeMutatorProvider::new).registerTypeFuzzer(CodeableConcept.class, CodeableConceptTypeMutatorProvider::new).registerTypeFuzzer(Coding.class, CodingMutatorProvider::new).registerTypeFuzzer(ContactDetail.class, ContactDetailMutatorProvider::new).registerTypeFuzzer(ContactPoint.class, ContactPointMutatorProvider::new).registerTypeFuzzer(Contributor.class, ContributorMutatorProvider::new).registerTypeFuzzer(DataRequirement.class, DataRequirementMutatorProvider::new).registerTypeFuzzer(DateTimeType.class, DateTimeTypeMutatorProvider::new).registerTypeFuzzer(DateType.class, DateTypeMutatorProvider::new).registerTypeFuzzer(DecimalType.class, DecimalTypeMutatorProvider::new).registerTypeFuzzer(Dosage.class, DosageMutatorProvider::new).registerTypeFuzzer(ElementDefinition.class, ElementDefinitionMutatorProvider::new).registerTypeFuzzer(Expression.class, ExpressionMutatorProvider::new).registerTypeFuzzer(Extension.class, ExtensionTypeMutatorProvider::new).registerTypeFuzzer(HumanName.class, HumanNameTypeMutatorProvider::new).registerTypeFuzzer(Identifier.class, IdentifierTypeMutatorProvider::new).registerTypeFuzzer(IdType.class, IdTypeMutatorProvider::new).registerTypeFuzzer(InstantType.class, InstantTypeMutatorProvider::new).registerTypeFuzzer(IntegerType.class, IntegerTypeMutatorProvider::new).registerTypeFuzzer(MarketingStatus.class, MarketingStatusMutatorProvider::new).registerTypeFuzzer(Meta.class, MetaTypeMutatorProvider::new).registerTypeFuzzer(Money.class, MoneyMutatorProvider::new).registerTypeFuzzer(Narrative.class, NarrativeMutatorProvider::new).registerTypeFuzzer(ParameterDefinition.class, ParameterDefinitionMutatorProvider::new).registerTypeFuzzer(Period.class, PeriodTypeMutatorProvider::new).registerTypeFuzzer(Population.class, PopulationMutatorProvider::new).registerTypeFuzzer(PositiveIntType.class, PositiveIntTypeMutatorProvider::new).registerTypeFuzzer(ProdCharacteristic.class, ProdCharacteristicMutatorProvider::new).registerTypeFuzzer(ProductShelfLife.class, ProductShelfLifeMutatorProvider::new).registerTypeFuzzer(Quantity.class, QuantityMutatorProvider::new).registerTypeFuzzer(Ratio.class, RatioMutatorProvider::new).registerTypeFuzzer(Range.class, RangeMutatorProvider::new).registerTypeFuzzer(Reference.class, ReferenceTypeMutatorProvider::new).registerTypeFuzzer(RelatedArtifact.class, RelatedArtifactMutatorProvider::new).registerTypeFuzzer(SampledData.class, SampleDataMutatorProvider::new).registerTypeFuzzer(Signature.class, SignatureMutatorProvider::new).registerTypeFuzzer(StringType.class, StringTypeMutatorProvider::new).registerTypeFuzzer(SubstanceAmount.class, SubstanceAmountMutatorProvider::new).registerTypeFuzzer(TimeType.class, TimeTypeMutatorProvider::new).registerTypeFuzzer(Timing.class, TimingTypeMutatorProvider::new).registerTypeFuzzer(TriggerDefinition.class, TriggerDefinitionMutatorProvider::new).registerTypeFuzzer(UnsignedIntType.class, UnsignedIntTypeMutatorProvider::new).registerTypeFuzzer(UriType.class, UriTypeMutatorProvider::new).registerTypeFuzzer(UsageContext.class, UsageContextMutatorProvider::new).registerPrimitiveTypeFuzzer(PrimitiveStringTypes.URI, PrimitiveUriMutatorProvider::new).registerPrimitiveTypeFuzzer(PrimitiveStringTypes.TEXT, PlainTextMutatorProvider::new).registerPrimitiveTypeFuzzer(PrimitiveStringTypes.CODE, CodeMutatorProvider::new);
        }

        public <R extends Resource> Builder registerResourceFuzzer(Class<R> rClass, Supplier<FhirResourceMutatorProvider<R>> fuzzerConstructor) {
            this.ctx.getResourceFuzzer().computeIfAbsent(rClass, k -> new LinkedList()).add(fuzzerConstructor.get());
            return this;
        }

        public <R extends Resource> Builder registerResourceMutator(Class<R> rClass, FuzzingMutator<R> mutator) {
            this.ctx.getResourceFuzzerFor(rClass).orElseThrow(() -> new FuzzerException(MessageFormat.format("No Fuzzer registered for resource {0}", rClass.getSimpleName()))).getMutators().add(mutator);
            return this;
        }

        public <T extends Type> Builder registerTypeFuzzer(Class<T> tClass, Supplier<FhirTypeMutatorProvider<T>> fuzzerConstructor) {
            this.ctx.getTypeFuzzer().computeIfAbsent(tClass, k -> new LinkedList()).add(fuzzerConstructor.get());
            return this;
        }

        public <T extends Type> Builder registerTypeMutator(Class<T> tClass, FuzzingMutator<T> mutator) {
            this.ctx.getTypeFuzzerFor(tClass).orElseThrow(() -> new FuzzerException(MessageFormat.format("No Fuzzer registered for type {0}", tClass.getSimpleName()))).getMutators().add(mutator);
            return this;
        }

        public <P> Builder registerPrimitiveTypeFuzzer(PrimitiveType<P> pType, Supplier<PrimitiveMutatorProvider<P>> fuzzerConstructor) {
            this.ctx.getPrimitiveFuzzer().computeIfAbsent(pType, k -> new LinkedList()).add(fuzzerConstructor.get());
            return this;
        }

        public <P> Builder registerPrimitiveMutator(PrimitiveType<P> pType, PrimitiveTypeMutator<P> mutator) {
            this.ctx.getPrimitiveFuzzerFor(pType).orElseThrow(() -> new FuzzerException(MessageFormat.format("No Fuzzer registered for type {0}", pType.getTypeClass()))).getMutators().add(mutator);
            return this;
        }

        public FuzzingEngine build() {
            return new FuzzingEngineImpl(this.ctx);
        }
    }
}

