/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl;

import de.gematik.bbriccs.fhir.fuzzing.FhirResourceMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FhirTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.FuzzingContext;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveType;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeFuzzingResponse;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeMutator;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.exceptions.FuzzerException;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.RootFuzzingLogEntry;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import lombok.Generated;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuzzingContextImpl
implements FuzzingContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FuzzingContextImpl.class);
    private final Randomness randomness;
    private final Map<Class<? extends Resource>, List<FhirResourceMutatorProvider<? extends Resource>>> resourceFuzzer;
    private final Map<Class<? extends Type>, List<FhirTypeMutatorProvider<? extends Type>>> typeFuzzer;
    private final Map<PrimitiveType<?>, List<PrimitiveMutatorProvider<?>>> primitiveFuzzer;

    public FuzzingContextImpl(Randomness randomness) {
        this.randomness = randomness;
        this.resourceFuzzer = new HashMap<Class<? extends Resource>, List<FhirResourceMutatorProvider<? extends Resource>>>();
        this.typeFuzzer = new HashMap<Class<? extends Type>, List<FhirTypeMutatorProvider<? extends Type>>>();
        this.primitiveFuzzer = new HashMap();
    }

    @Override
    public <R extends Resource> List<FuzzingLogEntry> startFuzzingSession(R resource) {
        Class<?> rClass = resource.getClass();
        List<FhirResourceMutatorProvider<?>> rClassFuzzers = this.getAllResourceFuzzersFor(rClass);
        if (rClassFuzzers.isEmpty()) {
            throw new FuzzerException(MessageFormat.format("Unable to start Fuzzing because no Fuzzer found for {0}", resource.getClass()));
        }
        return rClassFuzzers.stream().map(FhirResourceMutatorProvider::getMutators).flatMap(mutators -> {
            int mutatorAmount = this.randomness.source().nextInt(1, mutators.size() + 1);
            Collections.shuffle(mutators);
            return IntStream.range(0, mutatorAmount).mapToObj(mutators::get);
        }).map(mutator -> {
            try {
                return mutator.apply(this, resource);
            }
            catch (Throwable throwable) {
                return FuzzingLogEntry.error(throwable);
            }
        }).toList();
    }

    @Override
    public <R extends Resource> FuzzingLogEntry fuzzChild(String message, R resource) {
        log.trace("Fuzz Child Resource {}: {}", (Object)resource.getClass().getSimpleName(), (Object)message);
        List<FuzzingLogEntry> entries = this.callResourceFuzzersFor(resource.getClass(), resource);
        return FuzzingLogEntry.parent(message, entries);
    }

    @Override
    public <R extends Resource> FuzzingLogEntry fuzzChildResources(String message, List<R> resources) {
        log.trace("Fuzz Child {} Resources: {}", (Object)resources.size(), (Object)message);
        List<FuzzingLogEntry> entries = resources.stream().flatMap(resource -> this.callResourceFuzzersFor(resource.getClass(), resource).stream()).toList();
        return FuzzingLogEntry.parent(message, entries);
    }

    @Override
    public <T extends Type> FuzzingLogEntry fuzzChild(String message, T type) {
        if (type == null) {
            return FuzzingLogEntry.noop(MessageFormat.format("{0} but given type is null", message));
        }
        log.trace("Fuzz Child Type {}: {}", (Object)type.getClass().getSimpleName(), (Object)message);
        List<FuzzingLogEntry> entries = this.callTypeFuzzersFor(type.getClass(), type);
        return FuzzingLogEntry.parent(message, entries);
    }

    @Override
    public <T extends Type> FuzzingLogEntry fuzzChildTypes(String message, List<T> types) {
        log.trace("Fuzz {} Child Types: {}", (Object)types.size(), (Object)message);
        List<FuzzingLogEntry> entries = types.stream().flatMap(type -> this.callTypeFuzzersFor(type.getClass(), type).stream()).toList();
        return FuzzingLogEntry.parent(message, entries);
    }

    @Override
    public <R extends Resource> FuzzingLogEntry fuzzIdElement(Class<? extends Resource> parentClass, R parent) {
        if (parent == null) {
            return FuzzingLogEntry.noop(MessageFormat.format("do not fuzz ID-Element for {0} because the object is null", parentClass.getSimpleName()));
        }
        return this.fuzzIdElement(IdType.class, parent.getIdElement());
    }

    @Override
    public <T extends Type> FuzzingLogEntry fuzzIdElement(Class<T> parentClass, T parent) {
        if (parent == null) {
            return FuzzingLogEntry.noop(MessageFormat.format("do not fuzz ID-Element for {0} because the object is null", parentClass.getSimpleName()));
        }
        if (this.randomness.idDice().toss()) {
            log.trace("Fuzz ID-Element of {}", (Object)parentClass.getSimpleName());
            LinkedList<FuzzingLogEntry> childLogEntries = new LinkedList<FuzzingLogEntry>();
            if (!parent.hasIdElement()) {
                String value = this.randomness.id();
                StringType idElement = this.randomness.fhir().createType(StringType.class);
                idElement.setValue((Object)value);
                parent.setIdElement(idElement);
                childLogEntries.add(FuzzingLogEntry.operation("Add new StringType for ID-Element"));
            }
            StringType idElement = parent.getIdElement();
            childLogEntries.add(this.fuzzChild(parentClass, idElement));
            return FuzzingLogEntry.parent(MessageFormat.format("Fuzz ID-Element for {0}", parentClass.getSimpleName()), childLogEntries);
        }
        return FuzzingLogEntry.noop(MessageFormat.format("do not fuzz ID-Element for {0}", parentClass.getSimpleName()));
    }

    @Override
    public <P> PrimitiveTypeFuzzingResponse<P> fuzzPrimitiveType(String message, PrimitiveType<P> pType, P value) {
        log.trace("Fuzz Primitive Type {}: {}", pType, (Object)message);
        List mutators = this.getAllPrimitiveFuzzersFor(pType).stream().flatMap(f -> this.randomness.mutatorDice().chooseRandomElements(f.getMutators()).stream()).toList();
        LinkedList<FuzzingLogEntry> entries = new LinkedList<FuzzingLogEntry>();
        for (PrimitiveTypeMutator m : mutators) {
            PrimitiveTypeFuzzingResponse<P> response = m.apply(this, value);
            value = response.getFuzzedValue();
            entries.add(response.getLogEntry());
        }
        RootFuzzingLogEntry fullLog = FuzzingLogEntry.parent(message, entries);
        return PrimitiveTypeFuzzingResponse.response(value, fullLog);
    }

    @Override
    public Randomness randomness() {
        return this.randomness;
    }

    private <T extends Type> List<FuzzingLogEntry> callTypeFuzzersFor(Class<T> tClass, T typeValue) {
        List mutators = this.getAllTypeFuzzersFor(tClass).stream().flatMap(tf -> this.randomness.mutatorDice().chooseRandomElements(tf.getMutators()).stream()).toList();
        if (mutators.isEmpty()) {
            return List.of(FuzzingLogEntry.noop(MessageFormat.format("no TypeFuzzer found or chosen for {0} with ID ''{1}''", tClass.getSimpleName(), typeValue.getId())));
        }
        return mutators.stream().map(mutator -> {
            try {
                return mutator.apply(this, typeValue);
            }
            catch (Throwable throwable) {
                log.warn("Caught throwable {} while applying mutator", (Object)throwable.getClass().getSimpleName());
                return FuzzingLogEntry.error(throwable);
            }
        }).toList();
    }

    protected <T extends Type> Optional<FhirTypeMutatorProvider<T>> getTypeFuzzerFor(Class<T> tClass) {
        return this.randomness.chooseRandomly(this.getAllTypeFuzzersFor(tClass));
    }

    private <T extends Type> List<FhirTypeMutatorProvider<T>> getAllTypeFuzzersFor(Class<T> tClass) {
        ArrayList<FhirTypeMutatorProvider<T>> typeFuzzers = new ArrayList<FhirTypeMutatorProvider<T>>(this.typeFuzzer.computeIfAbsent(tClass, k -> new LinkedList()).stream().map(x -> x).toList());
        List<Class<T>> superClasses = this.getTypeHierarchy(tClass);
        List superMatches = superClasses.stream().flatMap(superClass -> this.typeFuzzer.computeIfAbsent((Class<? extends Type>)superClass, k -> new LinkedList()).stream().map(x -> x)).toList();
        typeFuzzers.addAll(superMatches);
        if (typeFuzzers.isEmpty()) {
            log.warn("No Fuzzers found for requested Type {}", (Object)tClass.getSimpleName());
        }
        return typeFuzzers;
    }

    protected <R extends Resource> Optional<FhirResourceMutatorProvider<R>> getResourceFuzzerFor(Class<R> rClass) {
        return this.randomness.chooseRandomly(this.getAllResourceFuzzersFor(rClass));
    }

    private <R extends Resource> List<FuzzingLogEntry> callResourceFuzzersFor(Class<R> rClass, R resource) {
        return this.getAllResourceFuzzersFor(rClass).stream().flatMap(rf -> this.randomness.mutatorDice().chooseRandomElements(rf.getMutators()).stream()).map(mutator -> mutator.apply(this, resource)).toList();
    }

    private <R extends Resource> List<FhirResourceMutatorProvider<R>> getAllResourceFuzzersFor(Class<R> rClass) {
        ArrayList<FhirResourceMutatorProvider<R>> resourceFuzzers = new ArrayList<FhirResourceMutatorProvider<R>>(this.resourceFuzzer.computeIfAbsent(rClass, k -> new LinkedList()).stream().map(x -> x).toList());
        List<Class<R>> resourceHierarchy = this.getResourceHierarchy(rClass);
        List hierarchyFuzzers = resourceHierarchy.stream().flatMap(superClass -> this.resourceFuzzer.computeIfAbsent((Class<? extends Resource>)superClass, k -> new LinkedList()).stream().map(x -> x)).toList();
        resourceFuzzers.addAll(hierarchyFuzzers);
        if (resourceFuzzers.isEmpty()) {
            log.warn("No Fuzzers found for requested Resource {}", (Object)rClass.getSimpleName());
        }
        return resourceFuzzers;
    }

    <P> Optional<PrimitiveMutatorProvider<P>> getPrimitiveFuzzerFor(PrimitiveType<P> pType) {
        return this.randomness.chooseRandomly(this.getAllPrimitiveFuzzersFor(pType));
    }

    private <P> List<PrimitiveMutatorProvider<P>> getAllPrimitiveFuzzersFor(PrimitiveType<P> pType) {
        List<PrimitiveMutatorProvider<P>> fuzzers = this.primitiveFuzzer.computeIfAbsent(pType, k -> new LinkedList()).stream().map(x -> x).toList();
        if (fuzzers.isEmpty()) {
            log.warn("No Fuzzers found for requested primitive type {}", pType);
        }
        return fuzzers;
    }

    private <S extends Resource> List<Class<S>> getResourceHierarchy(Class<S> rClass) {
        LinkedList<Class<S>> classHierarchy = new LinkedList<Class<S>>();
        for (Class<S> superClass = rClass.getSuperclass(); superClass != Resource.class; superClass = superClass.getSuperclass()) {
            classHierarchy.add(superClass);
        }
        return classHierarchy;
    }

    private <S extends Type> List<Class<S>> getTypeHierarchy(Class<S> tClass) {
        LinkedList<Class<S>> classHierarchy = new LinkedList<Class<S>>();
        for (Class<S> superType = tClass.getSuperclass(); superType != Type.class; superType = superType.getSuperclass()) {
            classHierarchy.add(superType);
        }
        return classHierarchy;
    }

    @Generated
    public Randomness getRandomness() {
        return this.randomness;
    }

    @Generated
    public Map<Class<? extends Resource>, List<FhirResourceMutatorProvider<? extends Resource>>> getResourceFuzzer() {
        return this.resourceFuzzer;
    }

    @Generated
    public Map<Class<? extends Type>, List<FhirTypeMutatorProvider<? extends Type>>> getTypeFuzzer() {
        return this.typeFuzzer;
    }

    @Generated
    public Map<PrimitiveType<?>, List<PrimitiveMutatorProvider<?>>> getPrimitiveFuzzer() {
        return this.primitiveFuzzer;
    }
}

