/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing;

import de.gematik.bbriccs.fhir.fuzzing.PrimitiveType;
import de.gematik.bbriccs.fhir.fuzzing.PrimitiveTypeFuzzingResponse;
import de.gematik.bbriccs.fhir.fuzzing.Randomness;
import de.gematik.bbriccs.fhir.fuzzing.impl.log.FuzzingLogEntry;
import java.text.MessageFormat;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Type;

public interface FuzzingContext {
    public <R extends Resource> List<FuzzingLogEntry> startFuzzingSession(R var1);

    public <R extends Resource> FuzzingLogEntry fuzzChild(String var1, R var2);

    default public <R extends Resource, P> FuzzingLogEntry fuzzChild(Class<P> parent, R resource) {
        String message = MessageFormat.format("Call ResourceFuzzers for {0} in {1}", resource.getClass().getSimpleName(), parent.getSimpleName());
        return this.fuzzChild(message, (Type)resource);
    }

    default public <R extends Resource, P> FuzzingLogEntry fuzzChildResources(Class<P> parent, List<R> resources) {
        String message = MessageFormat.format("Call ResourceFuzzers for {0} children resources of {1}", resources.size(), parent.getSimpleName());
        return this.fuzzChildResources(message, resources);
    }

    public <R extends Resource> FuzzingLogEntry fuzzChildResources(String var1, List<R> var2);

    default public <B extends Bundle> FuzzingLogEntry fuzzChildResources(B parent) {
        List<Resource> entryResource = this.randomness().childResourceDice().chooseRandomElements(parent.getEntry().stream().map(Bundle.BundleEntryComponent::getResource).toList());
        if (entryResource.isEmpty()) {
            return FuzzingLogEntry.noop(MessageFormat.format("Bundle {0} with ID ''{1}'' does not contain any resources", parent.getClass().getSimpleName(), parent.getId()));
        }
        String message = MessageFormat.format("Call ResourceFuzzers for Child-Resources in Bundle with ID ''{0}'':  {1}", parent.getId(), entryResource.stream().map(r -> r.getResourceType().name()).collect(Collectors.joining("/")));
        return this.fuzzChildResources(message, entryResource);
    }

    public <T extends Type> FuzzingLogEntry fuzzChild(String var1, T var2);

    default public <T extends Type, P> FuzzingLogEntry fuzzChild(Class<P> parent, T type) {
        String pClassName = parent.getSimpleName();
        if (type == null) {
            return FuzzingLogEntry.noop(MessageFormat.format("in {0} the given type is null", pClassName));
        }
        String message = MessageFormat.format("Call TypeFuzzers for {0} in {1}", type.getClass().getSimpleName(), pClassName);
        return this.fuzzChild(message, type);
    }

    default public <T extends Type, P> FuzzingLogEntry fuzzChild(P parent, BooleanSupplier hasType, Supplier<T> typeSupplier) {
        return this.fuzzChild(parent, hasType.getAsBoolean(), typeSupplier);
    }

    default public <T extends Type, P> FuzzingLogEntry fuzzChild(P parent, boolean hasType, Supplier<T> typeSupplier) {
        Type type;
        try {
            type = (Type)typeSupplier.get();
        }
        catch (Throwable throwable) {
            return FuzzingLogEntry.error(throwable);
        }
        String tClassName = type.getClass().getSimpleName();
        String pClassName = parent.getClass().getSimpleName();
        String message = MessageFormat.format("Call TypeFuzzers for {0} in {1}", tClassName, pClassName);
        FuzzingLogEntry childLog = this.fuzzChild(message, type);
        if (hasType) {
            return childLog;
        }
        String addTypeLog = MessageFormat.format("Add new Type {0} for {1}", tClassName, pClassName);
        return FuzzingLogEntry.add(addTypeLog, childLog);
    }

    public <T extends Type> FuzzingLogEntry fuzzChildTypes(String var1, List<T> var2);

    default public <T extends Type, P> FuzzingLogEntry fuzzChildTypes(Class<P> parent, List<T> types) {
        String pClassName = parent.getSimpleName();
        if (types.isEmpty()) {
            return FuzzingLogEntry.noop("given List of types is empty");
        }
        String message = MessageFormat.format("Call TypeFuzzers on {0} for type(s) {1}", pClassName, types.stream().map(Element::fhirType).collect(Collectors.joining("/")));
        return this.fuzzChildTypes(message, types);
    }

    default public <T extends Type, P> FuzzingLogEntry fuzzChildTypes(Class<P> parent, List<T> types, Supplier<T> addConstruction) {
        if (types.isEmpty()) {
            return this.fuzzChild(parent, false, addConstruction);
        }
        return this.fuzzChildTypes(parent, types);
    }

    public <R extends Resource> FuzzingLogEntry fuzzIdElement(Class<? extends Resource> var1, R var2);

    public <T extends Type> FuzzingLogEntry fuzzIdElement(Class<T> var1, T var2);

    public <P> PrimitiveTypeFuzzingResponse<P> fuzzPrimitiveType(String var1, PrimitiveType<P> var2, P var3);

    public Randomness randomness();
}

