/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import de.gematik.bbriccs.fhir.fuzzing.exceptions.FuzzerException;
import java.text.MessageFormat;
import java.util.Arrays;
import lombok.Generated;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Age;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Contributor;
import org.hl7.fhir.r4.model.Count;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.Distance;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.MarketingStatus;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.MoneyQuantity;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.OidType;
import org.hl7.fhir.r4.model.ParameterDefinition;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Population;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.ProdCharacteristic;
import org.hl7.fhir.r4.model.ProductShelfLife;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Ratio;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.SampledData;
import org.hl7.fhir.r4.model.Signature;
import org.hl7.fhir.r4.model.SimpleQuantity;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.SubstanceAmount;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.TriggerDefinition;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UrlType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r4.model.UuidType;

public enum FhirType {
    DATE(DateType.class),
    DATE_TIME(DateTimeType.class),
    INSTANT(InstantType.class),
    TIME(TimeType.class),
    META(Meta.class),
    MONEY_QUANTITY(MoneyQuantity.class),
    ADDRESS(Address.class),
    ATTACHMENT(Attachment.class),
    INTEGER_TYPE(IntegerType.class),
    INTEGER_POSITIVE_TYPE(PositiveIntType.class),
    INTEGER_UNSIGNED(UnsignedIntType.class),
    COUNT(Count.class),
    DATA_REQUIREMENT(DataRequirement.class),
    DOSAGE(Dosage.class),
    UUID(UuidType.class),
    IDENTIFIER(Identifier.class),
    SUBSTANCE_AMOUNT(SubstanceAmount.class),
    NARRATIVE(Narrative.class),
    CODING(Coding.class),
    SAMPLE_DATA(SampledData.class),
    ID(IdType.class),
    ELEMENT_DEFINITION(ElementDefinition.class),
    DISTANCE(Distance.class),
    PERIOD(Period.class),
    DURATION(Duration.class),
    CANONICAL(CanonicalType.class),
    RANGE(Range.class),
    RELATED_ARTIFACT(RelatedArtifact.class),
    PRODUCT_SHELF_LIFE(ProductShelfLife.class),
    BASE64_BINARY(Base64BinaryType.class),
    USAGE_CONTEXT(UsageContext.class),
    TIMING(Timing.class),
    DECIMAL(DecimalType.class),
    PROD_CHARACTERISTIC(ProdCharacteristic.class),
    CODEABLE_CONCEPT(CodeableConcept.class),
    CODE(CodeType.class),
    PARAMETER_DEFINITION(ParameterDefinition.class),
    STRING(StringType.class),
    CONTRIBUTOR(Contributor.class),
    OID(OidType.class),
    MONEY(Money.class),
    HUMAN_NAME(HumanName.class),
    CONTACT_POINT(ContactPoint.class),
    MARKETING_STATUS(MarketingStatus.class),
    MARKDOWN(MarkdownType.class),
    POPULATION(Population.class),
    RATIO(Ratio.class),
    AGE(Age.class),
    REFERENCE(Reference.class),
    TRIGGER_DEFINITION(TriggerDefinition.class),
    SIMPLE_QUANTITY(SimpleQuantity.class),
    QUANTITY(Quantity.class),
    URI(UriType.class),
    URL(UrlType.class),
    ANNOTATION(Annotation.class),
    EXTENSION(Extension.class),
    CONTACT_DETAIL(ContactDetail.class),
    BOOLEAN(BooleanType.class),
    EXPRESSION(Expression.class),
    SIGNATURE(Signature.class);

    private final Class<? extends Type> typeClass;

    public String getTypeName() {
        DatatypeDef dataTypeDef = Arrays.stream(this.typeClass.getAnnotations()).filter(a -> a.annotationType().equals(DatatypeDef.class)).map(a -> (DatatypeDef)a).findFirst().orElseThrow();
        return dataTypeDef.name();
    }

    public static <T extends Type> FhirType fromClass(Class<T> type) {
        return Arrays.stream(FhirType.values()).filter(ft -> ft.typeClass.equals(type)).findFirst().orElseThrow(() -> new FuzzerException(MessageFormat.format("No FhirType found for {0}", type.getSimpleName())));
    }

    @Generated
    private FhirType(Class<? extends Type> typeClass) {
        this.typeClass = typeClass;
    }
}

