/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.rnd;

import de.gematik.bbriccs.fhir.builder.exceptions.FakerException;
import de.gematik.bbriccs.fhir.fuzzing.ProbabilityDice;
import de.gematik.bbriccs.fhir.fuzzing.exceptions.FuzzerException;
import de.gematik.bbriccs.fhir.fuzzing.impl.rnd.ProbabilityDiceImpl;
import de.gematik.bbriccs.fhir.fuzzing.impl.rnd.RandomnessImpl;
import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RandomnessImplTest {
    private static final Random rnd = new SecureRandom();

    RandomnessImplTest() {
    }

    @Test
    void shouldThrowOnChoosingFromEmptyList() {
        ProbabilityDiceImpl dice = new ProbabilityDiceImpl(rnd, 1.0);
        RandomnessImpl randomness = new RandomnessImpl(rnd, (ProbabilityDice)dice, (ProbabilityDice)dice);
        List list = List.of();
        Assertions.assertThrows(FuzzerException.class, () -> randomness.chooseRandomElement(list));
    }

    @Test
    void shouldPickRandomlyFromList() {
        ProbabilityDiceImpl dice = new ProbabilityDiceImpl(rnd, 0.5);
        RandomnessImpl randomness = new RandomnessImpl(rnd, (ProbabilityDice)dice, (ProbabilityDice)dice);
        List<Integer> list = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        Integer element = (Integer)Assertions.assertDoesNotThrow(() -> (Integer)randomness.chooseRandomElement(list));
        Assertions.assertTrue((element > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((element < 4 ? 1 : 0) != 0);
    }

    @Test
    void shouldPickRandomEnum() {
        ProbabilityDiceImpl dice = new ProbabilityDiceImpl(rnd, 1.0);
        RandomnessImpl randomness = new RandomnessImpl(rnd, (ProbabilityDice)dice, (ProbabilityDice)dice);
        TestEnum e = (TestEnum)randomness.chooseRandomFromEnum(TestEnum.class);
        Assertions.assertNotNull((Object)((Object)e));
    }

    @Test
    void shouldPickRandomEnumExclude01() {
        ProbabilityDiceImpl dice = new ProbabilityDiceImpl(rnd, 1.0);
        RandomnessImpl randomness = new RandomnessImpl(rnd, (ProbabilityDice)dice, (ProbabilityDice)dice);
        TestEnum e = (TestEnum)randomness.chooseRandomFromEnum(TestEnum.class, (Enum)TestEnum.A);
        Assertions.assertNotNull((Object)((Object)e));
        Assertions.assertNotEquals((Object)((Object)TestEnum.A), (Object)((Object)e));
    }

    @Test
    void shouldPickRandomEnumExclude02() {
        ProbabilityDiceImpl dice = new ProbabilityDiceImpl(rnd, 1.0);
        RandomnessImpl randomness = new RandomnessImpl(rnd, (ProbabilityDice)dice, (ProbabilityDice)dice);
        TestEnum e = (TestEnum)randomness.chooseRandomFromEnum(TestEnum.class, List.of(TestEnum.A, TestEnum.B));
        Assertions.assertNotNull((Object)((Object)e));
        Assertions.assertNotEquals((Object)((Object)TestEnum.A), (Object)((Object)e));
        Assertions.assertNotEquals((Object)((Object)TestEnum.B), (Object)((Object)e));
    }

    @Test
    void shouldPickRandomEnumExclude03() {
        ProbabilityDiceImpl dice = new ProbabilityDiceImpl(rnd, 1.0);
        RandomnessImpl randomness = new RandomnessImpl(rnd, (ProbabilityDice)dice, (ProbabilityDice)dice);
        List<TestEnum> exclusion = List.of(TestEnum.A, TestEnum.B, TestEnum.C);
        Assertions.assertThrows(FakerException.class, () -> randomness.chooseRandomFromEnum(TestEnum.class, exclusion));
    }

    public static enum TestEnum {
        A,
        B,
        C;

    }
}

