/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.rnd;

import de.gematik.bbriccs.fhir.fuzzing.impl.rnd.ProbabilityDiceImpl;
import java.security.SecureRandom;
import java.util.Random;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

class ProbabilityDiceTest {
    private static final Random rnd = new SecureRandom();

    ProbabilityDiceTest() {
    }

    @ParameterizedTest
    @ValueSource(doubles={-1.0, -0.1, 1.1, 10.0})
    void shouldThrowOnInvalidProbability(double probability) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ProbabilityDiceImpl(rnd, probability));
    }

    @ParameterizedTest
    @MethodSource
    void shouldAlwaysTossTheSameOnEdgeProbabilities(double probability, boolean expectation) {
        ProbabilityDiceImpl dice = new ProbabilityDiceImpl(rnd, probability);
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals((Object)expectation, (Object)dice.toss());
        }
    }

    static Stream<Arguments> shouldAlwaysTossTheSameOnEdgeProbabilities() {
        return Stream.of(Arguments.of((Object[])new Object[]{1.0, true}), Arguments.of((Object[])new Object[]{0.0, false}));
    }
}

