/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.UsageContextMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UsageContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class UsageContextMutatorProviderTest
extends FhirFuzzingMutatorTest {
    UsageContextMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(UsageContext usageContext) {
        UsageContextMutatorProvider mutatorProvider = new UsageContextMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)usageContext));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)usageContext));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new UsageContext(), new UsageContext(new Coding(), (Type)new StringType("Fuzzing")), new UsageContext(new Coding(), (Type)new StringType("Fuzzing")).setExtension(List.of(new Extension("https://gematik.de/fhir/fuzzing", (IBaseDatatype)new StringType("fuzzy"))))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

