/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.UriTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.UriType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class UriTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    UriTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(UriType uriType) {
        UriTypeMutatorProvider mutatorProvider = new UriTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)uriType));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)uriType));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new UriType(), new UriType("https://de.wikipedia.org/wiki/Uniform_Resource_Identifier"), new UriType("file:///C:/Users/Benutzer/Desktop/Uniform%20Resource%20Identifier.html"), new UriType("sip:911@pbx.mycompany.com"), new UriType("git://github.com/rails/rails.git"), new UriType("")).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

