/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.UnsignedIntTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class UnsignedIntTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    UnsignedIntTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(UnsignedIntType uit) {
        UnsignedIntTypeMutatorProvider mutatorProvider = new UnsignedIntTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)uit));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)uit));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new UnsignedIntType(), new UnsignedIntType(Integer.MAX_VALUE), new UnsignedIntType(Integer.MIN_VALUE), new UnsignedIntType(Integer.MIN_VALUE).setExtension(List.of(new Extension("https://gematik.de/fhir/fuzzing")))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

