/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.TimingTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Timing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;
import org.mockito.Mockito;

class TimingTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    TimingTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(Timing timing) {
        TimingTypeMutatorProvider mutatorProvider = new TimingTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)timing));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)timing));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        Timing timingMock = (Timing)Mockito.mock(Timing.class);
        Timing.TimingRepeatComponent repeatMock = (Timing.TimingRepeatComponent)Mockito.mock(Timing.TimingRepeatComponent.class);
        Mockito.when((Object)timingMock.getRepeat()).thenReturn((Object)repeatMock);
        Mockito.when((Object)repeatMock.hasBounds()).thenReturn((Object)true);
        Mockito.when((Object)repeatMock.hasBoundsDuration()).thenReturn((Object)false);
        Mockito.when((Object)repeatMock.hasBoundsPeriod()).thenReturn((Object)false);
        Mockito.when((Object)repeatMock.hasBoundsRange()).thenReturn((Object)false);
        return Stream.of(new Timing(), timingMock, new Timing().addEvent(new Date()), new Timing().addEvent(new Date()).setExtension(List.of(new Extension("http://gematik.de/fhir/fuzz", (IBaseDatatype)new BooleanType(true))))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

