/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.TimeTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.TimeType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class TimeTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    TimeTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(TimeType timeType) {
        TimeTypeMutatorProvider mutatorProvider = new TimeTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)timeType));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)timeType));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new TimeType(), new TimeType("10:23:00"), new TimeType("10:23:01:1234"), new TimeType("10:23:01:1234").setExtension(List.of(new Extension("http://gematik.de/fhir/fuzz", (IBaseDatatype)new BooleanType(true))))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

