/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.SubstanceAmountMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.SubstanceAmount;
import org.hl7.fhir.r4.model.Type;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class SubstanceAmountMutatorProviderTest
extends FhirFuzzingMutatorTest {
    SubstanceAmountMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(SubstanceAmount substanceAmount) {
        SubstanceAmountMutatorProvider mutatorProvider = new SubstanceAmountMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)substanceAmount));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)substanceAmount));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new SubstanceAmount(), new SubstanceAmount().setAmount((Type)new Quantity()), new SubstanceAmount().setAmount((Type)new Quantity()).setReferenceRange(new SubstanceAmount.SubstanceAmountReferenceRangeComponent()), new SubstanceAmount().setAmount((Type)new Quantity()).setReferenceRange(new SubstanceAmount.SubstanceAmountReferenceRangeComponent()).setExtension(List.of(new Extension("https://gematik.de/fhir/fuzzing", (IBaseDatatype)new StringType("fuzzy"))))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

