/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.StringTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.StringType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class StringTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    StringTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(StringType stringType) {
        StringTypeMutatorProvider mutatorProvider = new StringTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)stringType));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)stringType));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new StringType(), new StringType("Hello World"), new StringType("file:///C:/Users/Benutzer/Desktop/Uniform%20Resource%20Identifier.html"), new StringType(""), new StringType(null)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

