/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.SignatureMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Signature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class SignatureMutatorProviderTest
extends FhirFuzzingMutatorTest {
    SignatureMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(Signature signature) {
        SignatureMutatorProvider mutatorProvider = new SignatureMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)signature));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)signature));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new Signature(), new Signature(new InstantType(new Date()), new Reference()), new Signature(new InstantType(new Date()), new Reference()).setExtension(List.of(new Extension("http://gematik.de/fhir/fuzz", (IBaseDatatype)new BooleanType(true))))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

