/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.ReferenceTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Reference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class ReferenceTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    ReferenceTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(Reference reference) {
        ReferenceTypeMutatorProvider mutatorProvider = new ReferenceTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)reference));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)reference));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new Reference(), new Reference("Hello/World"), new Reference("HelloWorld")).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

