/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.RatioMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Ratio;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class RatioMutatorProviderTest
extends FhirFuzzingMutatorTest {
    RatioMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(Ratio ratio) {
        RatioMutatorProvider mutatorProvider = new RatioMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)ratio));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)ratio));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new Ratio(), new Ratio().setDenominator(new Quantity().setValue(1L)).setNumerator(new Quantity(2L)), new Ratio().setDenominator(new Quantity().setValue(1L)).setNumerator(new Quantity(2L)).setExtension(List.of(new Extension("https://gematik.de/fhir/fuzzing")))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

