/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.RangeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Range;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class RangeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    RangeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(Range range) {
        RangeMutatorProvider mutatorProvider = new RangeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)range));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)range));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new Range(), new Range().setHigh(new Quantity().setValue(10L)).setLow(new Quantity(2L)), new Range().setHigh(new Quantity().setValue(10L)).setLow(new Quantity(2L)).setExtension(List.of(new Extension("https://gematik.de/fhir/fuzzing")))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

