/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.QuantityMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Quantity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class QuantityMutatorProviderTest
extends FhirFuzzingMutatorTest {
    QuantityMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(Quantity quantity) {
        QuantityMutatorProvider mutatorProvider = new QuantityMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)quantity));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)quantity));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new Quantity(), new Quantity(2.0), new Quantity(-4L), new Quantity(-4L).setCode("ABC").setSystem("https://gematik.de/fhir/fuzzing").setUnit("TBL")).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

