/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.PositiveIntTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class PositiveIntTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    PositiveIntTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(PositiveIntType pit) {
        PositiveIntTypeMutatorProvider mutatorProvider = new PositiveIntTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)pit));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)pit));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new PositiveIntType(), new PositiveIntType(Integer.MAX_VALUE), new PositiveIntType(Integer.MIN_VALUE), new PositiveIntType(Integer.MIN_VALUE).setExtension(List.of(new Extension("https://gematik.de/fhir/fuzzing")))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

