/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.ParameterDefinitionMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.ParameterDefinition;
import org.hl7.fhir.r4.model.StringType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class ParameterDefinitionMutatorProviderTest
extends FhirFuzzingMutatorTest {
    ParameterDefinitionMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(ParameterDefinition parameterDefinition) {
        ParameterDefinitionMutatorProvider mutatorProvider = new ParameterDefinitionMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)parameterDefinition));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)parameterDefinition));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new ParameterDefinition(), new ParameterDefinition().setUse(ParameterDefinition.ParameterUse.IN), new ParameterDefinition().setUse(ParameterDefinition.ParameterUse.IN).setExtension(List.of(new Extension("https://gematik.de/fhir/fuzzing", (IBaseDatatype)new StringType("fuzzy"))))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

