/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.NarrativeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class NarrativeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    NarrativeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(Narrative narrative) {
        NarrativeMutatorProvider mutatorProvider = new NarrativeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)narrative));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)narrative));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new Narrative(), new Narrative().setStatus(Narrative.NarrativeStatus.NULL), new Narrative().setStatus(Narrative.NarrativeStatus.ADDITIONAL).setDiv(new XhtmlNode().setName("p").setValue("fuzzy"))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

