/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.MoneyMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Money;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class MoneyMutatorProviderTest
extends FhirFuzzingMutatorTest {
    MoneyMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(Money money) {
        MoneyMutatorProvider mutatorProvider = new MoneyMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)money));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)money));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new Money(), new Money().setValue(123L), new Money().setValue(123L).setCurrency("EUR"), new Money().setValue(123L).setCurrency("EUR").setExtension(List.of(new Extension("https://gematik.de/fhir/fuzzing")))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

