/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.MarketingStatusMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.MarketingStatus;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.StringType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class MarketingStatusMutatorProviderTest
extends FhirFuzzingMutatorTest {
    MarketingStatusMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(MarketingStatus marketingStatus) {
        MarketingStatusMutatorProvider mutatorProvider = new MarketingStatusMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)marketingStatus));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)marketingStatus));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new MarketingStatus(), new MarketingStatus(new CodeableConcept(), new CodeableConcept(), new Period()), new MarketingStatus(new CodeableConcept(), new CodeableConcept(), new Period()).setExtension(List.of(new Extension("https://gematik.de/fhir/fuzzing", (IBaseDatatype)new StringType("fuzzy"))))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

