/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.IntegerTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class IntegerTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    IntegerTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(IntegerType it) {
        IntegerTypeMutatorProvider mutatorProvider = new IntegerTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)it));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)it));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new PositiveIntType(), new IntegerType(), new UnsignedIntType(123), new PositiveIntType(Integer.MAX_VALUE), new IntegerType(Integer.MAX_VALUE), new IntegerType(Integer.MIN_VALUE), new IntegerType(Integer.MIN_VALUE).setExtension(List.of(new Extension("https://gematik.de/fhir/fuzzing")))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

