/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.IdentifierTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Identifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class IdentifierTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    IdentifierTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(Identifier identifier) {
        IdentifierTypeMutatorProvider mutatorProvider = new IdentifierTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)identifier));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)identifier));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new Identifier(), new Identifier().setSystem("https://gematik.de/fhir/fuzzing"), new Identifier().setValue("160.100.000.000.037.28"), new Identifier().setType(new CodeableConcept(new Coding("https://gematik.de/fhir/fuzzing", "ABC", "Random Value for Fuzzing"))), new Identifier().setType(new CodeableConcept().setCoding(List.of()))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

