/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.IdTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.math.BigDecimal;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.IdType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class IdTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    IdTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(IdType idType) {
        IdTypeMutatorProvider mutatorProvider = new IdTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)idType));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)idType));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new IdType(), new IdType(new BigDecimal(123)), new IdType(456L), new IdType("some random value"), new IdType("Medication", new BigDecimal(789)), new IdType("Medication", Long.valueOf(12345L)), new IdType("Medication", "some ID", "0.1.2"), new IdType("https://gematik.de/fhir/fuzzing", "Medication", "some ID", "0.1.2")).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

