/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.HumanNameTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.StringType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class HumanNameTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    HumanNameTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(HumanName humanName) {
        HumanNameTypeMutatorProvider mutatorProvider = new HumanNameTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)humanName));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)humanName));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new HumanName(), new HumanName().setFamily("Mustermann").setGiven(List.of(new StringType("Max"))).setPrefix(List.of(new StringType("Dr. med."))), new HumanName().setPrefix(List.of(new StringType("Dr."))), new HumanName().setPeriod(new Period())).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

