/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.ExtensionTypeMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.StringType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class ExtensionTypeMutatorProviderTest
extends FhirFuzzingMutatorTest {
    ExtensionTypeMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(Extension extension) {
        ExtensionTypeMutatorProvider mutatorProvider = new ExtensionTypeMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)extension));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)extension));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new Extension(), new Extension("https://gematik.de/fhir/fuzzing"), new Extension("https://gematik.de/fhir/fuzzing", (IBaseDatatype)new StringType("fuzz")), new Extension().setExtension(List.of(new Extension("first", (IBaseDatatype)new StringType("abc")), new Extension("second", (IBaseDatatype)new BooleanType(true))))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

