/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types;

import de.gematik.bbriccs.fhir.fuzzing.impl.mutators.types.ElementDefinitionMutatorProvider;
import de.gematik.bbriccs.fhir.fuzzing.testutils.FhirFuzzingMutatorTest;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.StringType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class ElementDefinitionMutatorProviderTest
extends FhirFuzzingMutatorTest {
    ElementDefinitionMutatorProviderTest() {
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowAnything(ElementDefinition elementDefinition) {
        ElementDefinitionMutatorProvider mutatorProvider = new ElementDefinitionMutatorProvider();
        mutatorProvider.getMutators().forEach(m -> {
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)elementDefinition));
            Assertions.assertDoesNotThrow(() -> m.apply(this.ctx, (Object)elementDefinition));
        });
    }

    static Stream<Arguments> shouldNotThrowAnything() {
        return Stream.of(new ElementDefinition(), new ElementDefinition(new StringType("Fuzzing")), new ElementDefinition(new StringType("Fuzzing")).setDefinition("Random Test Element Definition"), new ElementDefinition(new StringType("Fuzzing")).setExtension(List.of(new Extension("https://gematik.de/fhir/fuzzing", (IBaseDatatype)new StringType("fuzzy"))))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

